/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.quaternary.io;

import java.io.IOException;
import java.util.List;
import org.biojava.nbio.core.util.SoftHashMap;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.biojava.nbio.structure.quaternary.io.BioUnitDataProvider;

public class PDBBioUnitDataProvider
implements BioUnitDataProvider {
    private SoftHashMap<String, PDBHeader> headerCache = new SoftHashMap(0);
    private Structure s;
    private AtomCache cache;

    public PDBHeader loadPDB(String pdbId) {
        FileParsingParameters params = null;
        if (this.cache == null) {
            this.cache = new AtomCache();
        }
        if ((params = this.cache.getFileParsingParams()) == null) {
            params = new FileParsingParameters();
        }
        params.setParseBioAssembly(true);
        params.setAlignSeqRes(true);
        PDBHeader header = null;
        try {
            this.s = this.cache.getStructure(pdbId);
            header = this.s.getPDBHeader();
            this.headerCache.put((Object)this.s.getPDBCode(), (Object)header);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (StructureException e) {
            e.printStackTrace();
        }
        return header;
    }

    @Override
    public Structure getAsymUnit(String pdbId) {
        if (this.s == null || !this.s.getPDBCode().equalsIgnoreCase(pdbId)) {
            this.loadPDB(pdbId);
        }
        if (this.s.nrModels() > 1) {
            this.s = StructureTools.removeModels(this.s);
        }
        return this.s;
    }

    @Override
    public void setAsymUnit(Structure s) {
        this.s = s;
    }

    @Override
    public List<BiologicalAssemblyTransformation> getBioUnitTransformationList(String pdbId, int biolAssemblyNr) {
        PDBHeader header = (PDBHeader)this.headerCache.get((Object)pdbId);
        if (header == null) {
            header = this.loadPDB(pdbId);
        }
        return header.getBioAssemblies().get(biolAssemblyNr).getTransforms();
    }

    @Override
    public int getNrBiolAssemblies(String pdbId) {
        PDBHeader header = (PDBHeader)this.headerCache.get((Object)pdbId);
        if (header == null) {
            header = this.loadPDB(pdbId);
        }
        return header.getNrBioAssemblies();
    }

    @Override
    public boolean hasBiolAssembly(String pdbId) {
        PDBHeader header = (PDBHeader)this.headerCache.get((Object)pdbId);
        if (header == null) {
            header = this.loadPDB(pdbId);
        }
        return header.getNrBioAssemblies() > 0;
    }

    @Override
    public void setAtomCache(AtomCache cache) {
        this.cache = cache;
    }

    @Override
    public AtomCache getAtomCache() {
        return this.cache;
    }
}

