/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.scop;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.biojava.nbio.structure.align.client.JFatCatClient;
import org.biojava.nbio.structure.align.util.HTTPConnectionTools;
import org.biojava.nbio.structure.scop.ScopCategory;
import org.biojava.nbio.structure.scop.ScopDatabase;
import org.biojava.nbio.structure.scop.ScopDescription;
import org.biojava.nbio.structure.scop.ScopDomain;
import org.biojava.nbio.structure.scop.ScopFactory;
import org.biojava.nbio.structure.scop.ScopNode;
import org.biojava.nbio.structure.scop.server.ScopDescriptions;
import org.biojava.nbio.structure.scop.server.ScopDomains;
import org.biojava.nbio.structure.scop.server.ScopNodes;
import org.biojava.nbio.structure.scop.server.XMLUtil;

public class RemoteScopInstallation
implements ScopDatabase {
    public static final String DEFAULT_SERVER = "http://source.rcsb.org/jfatcatserver/domains/";
    String server = "http://source.rcsb.org/jfatcatserver/domains/";
    private String version = null;

    public static void main(String[] args) {
        RemoteScopInstallation scop = new RemoteScopInstallation();
        ScopFactory.setScopDatabase(scop);
        System.out.println(scop.getDomainsForPDB("4HHB"));
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    @Override
    public List<ScopDescription> getByCategory(ScopCategory category) {
        List<ScopDescription> results = null;
        try {
            URL u = new URL(this.server + "getByCategory?category=" + category + "&version=" + this.getScopVersion());
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            if (!xml.trim().isEmpty()) {
                ScopDescriptions container = ScopDescriptions.fromXML(xml);
                results = container.getScopDescription();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to reach " + this.server + "getByCategory?category=" + category + "&version=" + this.getScopVersion(), e);
        }
        return results;
    }

    @Override
    public List<ScopDescription> filterByClassificationId(String query) {
        List<ScopDescription> results = null;
        try {
            URL u = new URL(this.server + "filterByClassificationId?query=" + query + "&version=" + this.getScopVersion());
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            if (!xml.trim().isEmpty()) {
                ScopDescriptions container = ScopDescriptions.fromXML(xml);
                results = container.getScopDescription();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to reach " + this.server + "filterByClassificationId?query=" + query + "&version=" + this.getScopVersion(), e);
        }
        return results;
    }

    @Override
    public List<ScopNode> getTree(ScopDomain domain) {
        List<ScopNode> results = null;
        try {
            URL u = new URL(this.server + "getTree?scopId=" + domain.getScopId() + "&version=" + this.getScopVersion());
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            if (!xml.trim().isEmpty()) {
                ScopNodes container = ScopNodes.fromXML(xml);
                results = container.getScopNode();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to reach " + this.server + "getTree?scopId=" + domain.getScopId() + "&version=" + this.getScopVersion(), e);
        }
        return results;
    }

    @Override
    public List<ScopDomain> filterByDomainName(String query) {
        query = query.trim();
        List<ScopDomain> results = null;
        try {
            URL u = new URL(this.server + "filterByDomainName?query=" + query + "&version=" + this.getScopVersion());
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            if (!xml.trim().isEmpty()) {
                ScopDomains container = ScopDomains.fromXML(xml);
                results = container.getScopDomain();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to reach " + this.server + "filterByDomainName?query=" + query + "&version=" + this.getScopVersion(), e);
        }
        return results;
    }

    @Override
    public List<ScopDescription> filterByDescription(String query) {
        List<ScopDescription> results = null;
        try {
            URL u = new URL(this.server + "filterByDescription?query=" + query + "&version=" + this.getScopVersion());
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            if (!xml.trim().isEmpty()) {
                ScopDescriptions container = ScopDescriptions.fromXML(xml);
                results = container.getScopDescription();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to reach " + this.server + "filterByDescription?query=" + query + "&version=" + this.getScopVersion(), e);
        }
        return results;
    }

    @Override
    public ScopDescription getScopDescriptionBySunid(int sunid) {
        ScopDescription desc = null;
        try {
            URL u = new URL(this.server + "getScopDescriptionBySunid?sunid=" + sunid + "&version=" + this.getScopVersion());
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            if (!xml.trim().isEmpty()) {
                desc = XMLUtil.getScopDescriptionFromXML(xml);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to reach " + this.server + "getScopDescriptionBySunid?sunid=" + sunid + "&version=" + this.getScopVersion(), e);
        }
        return desc;
    }

    @Override
    public List<ScopDomain> getDomainsForPDB(String pdbId) {
        List<ScopDomain> results = null;
        try {
            URL u = new URL(this.server + "getDomainsForPDB?pdbId=" + pdbId + "&version=" + this.getScopVersion());
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            if (!xml.trim().isEmpty()) {
                ScopDomains container = ScopDomains.fromXML(xml);
                results = container.getScopDomain();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to reach " + this.server + "getDomainsForPDB?pdbId=" + pdbId + "&version=" + this.getScopVersion(), e);
        }
        return results;
    }

    private ScopDomain requestRemoteDomainByScopID(String scopId) throws IOException {
        scopId = scopId.trim();
        URL u = new URL(this.server + "getDomainByScopID?scopId=" + scopId + "&version=" + this.getScopVersion());
        InputStream response = HTTPConnectionTools.getInputStream(u);
        String xml = JFatCatClient.convertStreamToString(response);
        if (!xml.trim().isEmpty()) {
            return XMLUtil.getScopDomainFromXML(xml);
        }
        return null;
    }

    @Override
    public ScopDomain getDomainByScopID(String scopId) {
        try {
            return this.requestRemoteDomainByScopID(scopId);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to reach " + this.server + "getDomainByScopID?scopId=" + scopId + "&version=" + this.getScopVersion(), e);
        }
    }

    @Override
    public ScopNode getScopNode(int sunid) {
        ScopNode desc = null;
        try {
            URL u = new URL(this.server + "getScopNode?sunid=" + sunid + "&version=" + this.getScopVersion());
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            if (!xml.trim().isEmpty()) {
                desc = XMLUtil.getScopNodeFromXML(xml);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to reach " + this.server + "getScopNode?sunid=" + sunid + "&version=" + this.getScopVersion(), e);
        }
        return desc;
    }

    @Override
    public String getScopVersion() {
        if (this.version == null) {
            try {
                URL u = new URL(this.server + "getScopVersion");
                InputStream response = HTTPConnectionTools.getInputStream(u);
                this.version = JFatCatClient.convertStreamToString(response);
                if (this.version != null) {
                    this.version = this.version.trim();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to reach " + this.server + "getScopVersion", e);
            }
        }
        return this.version;
    }

    @Override
    public void setScopVersion(String version) {
        this.version = version;
    }

    @Override
    public List<ScopDomain> getScopDomainsBySunid(Integer sunid) {
        List<ScopDomain> results = null;
        try {
            URL u = new URL(this.server + "getScopDomainsBySunid?sunid=" + sunid + "&version=" + this.getScopVersion());
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            if (!xml.trim().isEmpty()) {
                ScopDomains container = ScopDomains.fromXML(xml);
                results = container.getScopDomain();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to reach " + this.server + "getScopDomainsBySunid?sunid=" + sunid + "&version=" + this.getScopVersion(), e);
        }
        return results;
    }

    @Override
    public List<String> getComments(int sunid) {
        List<String> results = null;
        try {
            URL u = new URL(this.server + "getComments?sunid=" + sunid + "&version=" + this.getScopVersion());
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            if (!xml.trim().isEmpty()) {
                results = XMLUtil.getCommentsFromXML(xml);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to reach " + this.server + "getComments?sunid=" + sunid + "&version=" + this.getScopVersion(), e);
        }
        return results;
    }
}

