/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.symmetry.core.Helix;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryScores;

public class HelixLayers {
    private List<Helix> helices = new ArrayList<Helix>();
    private double symmetryDeviation = 0.0;

    public int size() {
        return this.helices.size();
    }

    public void addHelix(Helix helix) {
        this.helices.add(helix);
    }

    public Helix getHelix(int index) {
        return this.helices.get(index);
    }

    public Helix getByLowestAngle() {
        double angle = Double.MAX_VALUE;
        Helix lowest = null;
        for (Helix helix : this.helices) {
            if (!(helix.getAngle() < angle)) continue;
            angle = helix.getAngle();
            lowest = helix;
        }
        return lowest;
    }

    public Helix getByLargestContacts() {
        double contacts = 0.0;
        Helix largest = null;
        for (Helix helix : this.helices) {
            if (!((double)helix.getContacts() > contacts)) continue;
            contacts = helix.getContacts();
            largest = helix;
        }
        return largest;
    }

    public Helix getByLargestContactsNotLowestAngle() {
        double contacts = 0.0;
        Helix lowest = this.getByLowestAngle();
        double angle = lowest.getAngle() + 0.05;
        Helix largest = null;
        for (Helix helix : this.helices) {
            if (helix == lowest || !((double)helix.getContacts() > contacts) || !(helix.getAngle() > angle)) continue;
            contacts = helix.getContacts();
            largest = helix;
        }
        if (largest == null) {
            return lowest;
        }
        return largest;
    }

    public QuatSymmetryScores getScores() {
        int i;
        QuatSymmetryScores scores = new QuatSymmetryScores();
        double[] values = new double[this.helices.size()];
        for (i = 0; i < this.helices.size(); ++i) {
            values[i] = this.helices.get(i).getScores().getMinRmsd();
        }
        scores.setMinRmsd(this.minScores(values));
        for (i = 0; i < this.helices.size(); ++i) {
            values[i] = this.helices.get(i).getScores().getMaxRmsd();
        }
        scores.setMaxRmsd(this.maxScores(values));
        for (i = 0; i < this.helices.size(); ++i) {
            values[i] = this.helices.get(i).getScores().getRmsd();
        }
        scores.setRmsd(this.averageScores(values));
        for (i = 0; i < this.helices.size(); ++i) {
            values[i] = this.helices.get(i).getScores().getMinTm();
        }
        scores.setMinTm(this.minScores(values));
        for (i = 0; i < this.helices.size(); ++i) {
            values[i] = this.helices.get(i).getScores().getMaxTm();
        }
        scores.setMaxTm(this.maxScores(values));
        for (i = 0; i < this.helices.size(); ++i) {
            values[i] = this.helices.get(i).getScores().getTm();
        }
        scores.setTm(this.averageScores(values));
        for (i = 0; i < this.helices.size(); ++i) {
            values[i] = this.helices.get(i).getScores().getRmsdCenters();
        }
        scores.setRmsdCenters(this.averageScores(values));
        for (i = 0; i < this.helices.size(); ++i) {
            values[i] = this.helices.get(i).getScores().getTmIntra();
        }
        scores.setTmIntra(this.averageScores(values));
        for (i = 0; i < this.helices.size(); ++i) {
            values[i] = this.helices.get(i).getScores().getRmsdIntra();
        }
        scores.setRmsdIntra(this.averageScores(values));
        scores.setSymDeviation(this.symmetryDeviation);
        return scores;
    }

    public void setSymmetryDeviation(double symmetryDeviation) {
        this.symmetryDeviation = symmetryDeviation;
    }

    private double averageScores(double[] scores) {
        double sum = 0.0;
        for (double s : scores) {
            sum += s;
        }
        return sum / (double)scores.length;
    }

    private double minScores(double[] scores) {
        double score = Double.MAX_VALUE;
        for (double s : scores) {
            score = Math.min(score, s);
        }
        return score;
    }

    private double maxScores(double[] scores) {
        double score = Double.MIN_VALUE;
        for (double s : scores) {
            score = Math.max(score, s);
        }
        return score;
    }

    public void clear() {
        this.helices.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Helices: " + this.size() + "\n");
        for (Helix s : this.helices) {
            sb.append(s.toString() + "\n");
        }
        return sb.toString();
    }
}

