/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import org.biojava.nbio.structure.symmetry.core.HelixLayers;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryScores;
import org.biojava.nbio.structure.symmetry.core.RotationGroup;
import org.biojava.nbio.structure.symmetry.core.Subunits;

public class QuatSymmetryResults {
    private Subunits subunits = null;
    private RotationGroup rotationGroup = null;
    private HelixLayers helixLayers = null;
    private String method = null;
    private double sequenceIdentityThreshold = 0.0;
    private boolean local = false;
    private boolean preferredResult = false;

    public QuatSymmetryResults(Subunits subunits, RotationGroup rotationGroup, String method) {
        this.subunits = subunits;
        this.rotationGroup = rotationGroup;
        this.method = method;
    }

    public QuatSymmetryResults(Subunits subunits, HelixLayers helixLayers, String method) {
        this.subunits = subunits;
        this.helixLayers = helixLayers;
        this.method = method;
    }

    public Subunits getSubunits() {
        return this.subunits;
    }

    public RotationGroup getRotationGroup() {
        return this.rotationGroup;
    }

    public HelixLayers getHelixLayers() {
        return this.helixLayers;
    }

    public String getMethod() {
        return this.method;
    }

    public String getSymmetry() {
        if (this.helixLayers != null && this.helixLayers.size() > 0) {
            return "H";
        }
        if (this.rotationGroup != null && this.rotationGroup.getOrder() > 0) {
            return this.rotationGroup.getPointGroup();
        }
        return "";
    }

    public QuatSymmetryScores getScores() {
        if (this.helixLayers != null && this.helixLayers.size() > 0) {
            return this.helixLayers.getScores();
        }
        if (this.rotationGroup != null && this.rotationGroup.getOrder() > 0) {
            return this.rotationGroup.getScores();
        }
        return new QuatSymmetryScores();
    }

    @Deprecated
    public double getAverageTraceRmsd() {
        if (this.helixLayers != null && this.helixLayers.size() > 0) {
            return this.helixLayers.getScores().getRmsd();
        }
        if (this.rotationGroup != null && this.rotationGroup.getOrder() > 0) {
            return this.rotationGroup.getScores().getRmsd();
        }
        return 0.0;
    }

    @Deprecated
    public double getAverageTraceTmScoreMin() {
        if (this.helixLayers != null && this.helixLayers.size() > 0) {
            return this.helixLayers.getScores().getTm();
        }
        if (this.rotationGroup != null && this.rotationGroup.getOrder() > 0) {
            return this.rotationGroup.getScores().getTm();
        }
        return 0.0;
    }

    public int getNucleicAcidChainCount() {
        return this.subunits.getNucleicAcidChainCount();
    }

    public double getSequenceIdentityThreshold() {
        return this.sequenceIdentityThreshold;
    }

    public void setSequenceIdentityThreshold(double sequenceIdentityThreshold) {
        this.sequenceIdentityThreshold = sequenceIdentityThreshold;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Stoichiometry         : ");
        sb.append(this.getSubunits().getStoichiometry());
        sb.append("\n");
        sb.append("Pseudostoichiometry   : ");
        sb.append(this.getSubunits().isPseudoStoichiometric());
        sb.append("\n");
        sb.append("Pseudosymmetry        : ");
        sb.append(this.getSubunits().isPseudoSymmetric());
        sb.append("\n");
        sb.append("Min sequence identity : ");
        sb.append(Math.round(this.getSubunits().getMinSequenceIdentity() * 100.0));
        sb.append("\n");
        sb.append("Max sequence identity : ");
        sb.append(Math.round(this.getSubunits().getMaxSequenceIdentity() * 100.0));
        sb.append("\n");
        sb.append("Symmetry              : ");
        sb.append(this.getSymmetry());
        sb.append("\n");
        sb.append("Symmetry RMSD         : ");
        sb.append((float)this.getAverageTraceRmsd());
        sb.append("\n");
        sb.append("Symmetry TmScoreMin   : ");
        sb.append((float)this.getAverageTraceTmScoreMin());
        sb.append("\n");
        sb.append("Prefered result       : ");
        sb.append(this.isPreferredResult());
        sb.append("\n");
        return sb.toString();
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean isPreferredResult() {
        return this.preferredResult;
    }

    public void setPreferredResult(boolean preferredResult) {
        this.preferredResult = preferredResult;
    }
}

