/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.geometry;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.jama.EigenvalueDecomposition;
import org.biojava.nbio.structure.jama.Matrix;

public final class SuperPosition {
    public static Matrix4d superpose(Point3d[] x, Point3d[] y) {
        Point3d[] ref = SuperPosition.clonePoint3dArray(y);
        Point3d ytrans = SuperPosition.centroid(ref);
        ytrans.negate();
        SuperPosition.translate(ytrans, ref);
        SuperPosition.center(x);
        Quat4d q = SuperPosition.quaternionOrientation(x, ref);
        Matrix4d rotTrans = new Matrix4d();
        rotTrans.set(q);
        ytrans.negate();
        rotTrans.setTranslation(new Vector3d((Tuple3d)ytrans));
        SuperPosition.transform(rotTrans, x);
        return rotTrans;
    }

    public static Matrix4d superposeWithTranslation(Point3d[] x, Point3d[] y) {
        Point3d[] xref = SuperPosition.clonePoint3dArray(x);
        Point3d xtrans = SuperPosition.centroid(xref);
        xtrans.negate();
        SuperPosition.translate(xtrans, xref);
        Point3d[] yref = SuperPosition.clonePoint3dArray(y);
        Point3d ytrans = SuperPosition.centroid(yref);
        ytrans.negate();
        SuperPosition.translate(ytrans, yref);
        Quat4d q = SuperPosition.quaternionOrientation(xref, yref);
        Matrix4d rotTrans = new Matrix4d();
        rotTrans.set(q);
        Matrix4d trans = new Matrix4d();
        trans.setIdentity();
        trans.setTranslation(new Vector3d((Tuple3d)xtrans));
        rotTrans.mul(rotTrans, trans);
        ytrans.negate();
        Matrix4d transInverse = new Matrix4d();
        transInverse.setIdentity();
        transInverse.setTranslation(new Vector3d((Tuple3d)ytrans));
        rotTrans.mul(transInverse, rotTrans);
        SuperPosition.transform(rotTrans, x);
        return rotTrans;
    }

    public static Matrix4d superposeAtOrigin(Point3d[] x, Point3d[] y) {
        Quat4d q = SuperPosition.quaternionOrientation(x, y);
        Matrix4d rotTrans = new Matrix4d();
        rotTrans.set(q);
        return rotTrans;
    }

    public static Matrix4d superposeAtOrigin(Point3d[] x, Point3d[] y, AxisAngle4d axisAngle) {
        Quat4d q = SuperPosition.quaternionOrientation(x, y);
        Matrix4d rotTrans = new Matrix4d();
        rotTrans.setIdentity();
        rotTrans.set(q);
        axisAngle.set(q);
        Vector3d axis = new Vector3d(axisAngle.x, axisAngle.y, axisAngle.z);
        if (axis.lengthSquared() < 1.0E-6) {
            axisAngle.x = 0.0;
            axisAngle.y = 0.0;
            axisAngle.z = 1.0;
            axisAngle.angle = 0.0;
        } else {
            axis.normalize();
            axisAngle.x = axis.x;
            axisAngle.y = axis.y;
            axisAngle.z = axis.z;
        }
        SuperPosition.transform(rotTrans, x);
        return rotTrans;
    }

    public static double rmsd(Point3d[] x, Point3d[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i].distanceSquared(y[i]);
        }
        return Math.sqrt(sum / (double)x.length);
    }

    public static double rmsdMin(Point3d[] x, Point3d[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double minDist = Double.MAX_VALUE;
            for (int j = 0; j < y.length; ++j) {
                minDist = Math.min(minDist, x[i].distanceSquared(y[j]));
            }
            sum += minDist;
        }
        return Math.sqrt(sum / (double)x.length);
    }

    public static double TMScore(Point3d[] x, Point3d[] y, int lengthNative) {
        double d0 = 1.24 * Math.cbrt((double)x.length - 15.0) - 1.8;
        double d0Sq = d0 * d0;
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += 1.0 / (1.0 + x[i].distanceSquared(y[i]) / d0Sq);
        }
        return sum / (double)lengthNative;
    }

    public static double GTSlikeScore(Point3d[] x, Point3d[] y) {
        int contacts = 0;
        for (Point3d px : x) {
            double minDist = Double.MAX_VALUE;
            for (Point3d py : y) {
                minDist = Math.min(minDist, px.distanceSquared(py));
            }
            if (minDist > 64.0) continue;
            ++contacts;
            if (minDist > 16.0) continue;
            ++contacts;
            if (minDist > 4.0) continue;
            ++contacts;
            if (minDist > 1.0) continue;
            ++contacts;
        }
        return (double)contacts * 25.0 / (double)x.length;
    }

    public static int contacts(Point3d[] x, Point3d[] y, double maxDistance) {
        int contacts = 0;
        for (int i = 0; i < x.length; ++i) {
            double minDist = Double.MAX_VALUE;
            for (int j = 0; j < y.length; ++j) {
                minDist = Math.min(minDist, x[i].distanceSquared(y[j]));
            }
            if (!(minDist < maxDistance * maxDistance)) continue;
            ++contacts;
        }
        return contacts;
    }

    public static void transform(Matrix4d rotTrans, Point3d[] x) {
        for (Point3d p : x) {
            rotTrans.transform(p);
        }
    }

    public static void translate(Point3d trans, Point3d[] x) {
        for (Point3d p : x) {
            p.add((Tuple3d)trans);
        }
    }

    public static void center(Point3d[] x) {
        Point3d center = SuperPosition.centroid(x);
        center.negate();
        SuperPosition.translate(center, x);
    }

    public static Point3d centroid(Point3d[] x) {
        Point3d center = new Point3d();
        for (Point3d p : x) {
            center.add((Tuple3d)p);
        }
        center.scale(1.0 / (double)x.length);
        return center;
    }

    private static Quat4d quaternionOrientation(Point3d[] a, Point3d[] b) {
        Matrix m = SuperPosition.calcFormMatrix(a, b);
        EigenvalueDecomposition eig = m.eig();
        double[][] v = eig.getV().getArray();
        Quat4d q = new Quat4d(v[1][3], v[2][3], v[3][3], v[0][3]);
        q.normalize();
        q.conjugate();
        return q;
    }

    private static Matrix calcFormMatrix(Point3d[] a, Point3d[] b) {
        double xx = 0.0;
        double xy = 0.0;
        double xz = 0.0;
        double yx = 0.0;
        double yy = 0.0;
        double yz = 0.0;
        double zx = 0.0;
        double zy = 0.0;
        double zz = 0.0;
        for (int i = 0; i < a.length; ++i) {
            xx += a[i].x * b[i].x;
            xy += a[i].x * b[i].y;
            xz += a[i].x * b[i].z;
            yx += a[i].y * b[i].x;
            yy += a[i].y * b[i].y;
            yz += a[i].y * b[i].z;
            zx += a[i].z * b[i].x;
            zy += a[i].z * b[i].y;
            zz += a[i].z * b[i].z;
        }
        double[][] f = new double[4][4];
        f[0][0] = xx + yy + zz;
        f[0][1] = zy - yz;
        f[1][0] = f[0][1];
        f[1][1] = xx - yy - zz;
        f[0][2] = xz - zx;
        f[2][0] = f[0][2];
        f[1][2] = xy + yx;
        f[2][1] = f[1][2];
        f[2][2] = yy - zz - xx;
        f[0][3] = yx - xy;
        f[3][0] = f[0][3];
        f[1][3] = zx + xz;
        f[3][1] = f[1][3];
        f[2][3] = yz + zy;
        f[3][2] = f[2][3];
        f[3][3] = zz - xx - yy;
        return new Matrix(f);
    }

    public static Point3d[] clonePoint3dArray(Point3d[] x) {
        Point3d[] clone = new Point3d[x.length];
        for (int i = 0; i < x.length; ++i) {
            clone[i] = new Point3d(x[i]);
        }
        return clone;
    }
}

