/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.util.AlignmentTools;
import org.biojava.nbio.structure.symmetry.internal.RefinerFailedException;
import org.biojava.nbio.structure.symmetry.internal.SymmetryRefiner;
import org.biojava.nbio.structure.symmetry.utils.SymmetryTools;

public class SequenceFunctionRefiner
implements SymmetryRefiner {
    @Override
    public MultipleAlignment refine(AFPChain selfAlignment, Atom[] atoms, int order) throws RefinerFailedException, StructureException {
        if (order < 2) {
            throw new RefinerFailedException("Symmetry not found in the structure: order < 2.");
        }
        AFPChain afp = SequenceFunctionRefiner.refineSymmetry(selfAlignment, atoms, atoms, order);
        return SymmetryTools.fromAFP(afp, atoms);
    }

    public static AFPChain refineSymmetry(AFPChain afpChain, Atom[] ca1, Atom[] ca2, int k) throws StructureException, RefinerFailedException {
        Map<Integer, Integer> alignment = AlignmentTools.alignmentAsMap(afpChain);
        Map<Integer, Integer> refined = SequenceFunctionRefiner.refineSymmetry(alignment, k);
        if (refined.size() < 1) {
            throw new RefinerFailedException("Refiner returned empty alignment");
        }
        try {
            AFPChain refinedAFP = AlignmentTools.replaceOptAln(afpChain, ca1, ca2, refined);
            refinedAFP = SequenceFunctionRefiner.partitionAFPchain(refinedAFP, ca1, ca2, k);
            if (refinedAFP.getOptLength() < 1) {
                throw new IndexOutOfBoundsException("Refined alignment is empty.");
            }
            return refinedAFP;
        }
        catch (IndexOutOfBoundsException e) {
            throw new RefinerFailedException("Refiner failure: non-consistent result", e);
        }
    }

    public static Map<Integer, Integer> refineSymmetry(Map<Integer, Integer> alignment, int k) throws StructureException {
        Map<Integer, Double> scores = null;
        scores = SequenceFunctionRefiner.initializeScores(alignment, scores, k);
        TreeSet<Integer> forwardLoops = new TreeSet<Integer>();
        TreeSet<Integer> backwardLoops = new TreeSet<Integer>();
        List<Integer> eligible = null;
        eligible = SequenceFunctionRefiner.initializeEligible(alignment, scores, eligible, k, forwardLoops, backwardLoops);
        while (!eligible.isEmpty()) {
            Integer bestRes = null;
            double bestResScore = Double.POSITIVE_INFINITY;
            for (Integer res : eligible) {
                Double score = scores.get(res);
                if (score == null || !(score < bestResScore)) continue;
                bestResScore = score;
                bestRes = res;
            }
            Integer resK1 = bestRes;
            for (int i = 0; i < k - 1; ++i) {
                assert (resK1 != null);
                resK1 = alignment.get(resK1);
                scores.put(resK1, 0.0);
            }
            scores.put(bestRes, 0.0);
            alignment.put(resK1, bestRes);
            scores = SequenceFunctionRefiner.initializeScores(alignment, scores, k);
            Map<Integer, Double> virginScores = SequenceFunctionRefiner.initializeScores(alignment, null, k);
            if (scores.size() != virginScores.size()) {
                System.out.println("Size missmatch");
            } else {
                for (Integer key : scores.keySet()) {
                    if (virginScores.containsKey(key) && scores.get(key).equals(virginScores.get(key))) continue;
                    System.out.format("Mismatch %d -> %f/%f%n", key, scores.get(key), virginScores.get(key));
                }
            }
            eligible = SequenceFunctionRefiner.initializeEligible(alignment, scores, eligible, k, forwardLoops, backwardLoops);
        }
        Iterator<Integer> alignmentIt = alignment.keySet().iterator();
        while (alignmentIt.hasNext()) {
            Integer res = alignmentIt.next();
            Double score = scores.get(res);
            if (score != null && !(score > 0.0)) continue;
            alignmentIt.remove();
        }
        return alignment;
    }

    private static List<Integer> initializeEligible(Map<Integer, Integer> alignment, Map<Integer, Double> scores, List<Integer> eligible, int k, NavigableSet<Integer> forwardLoops, NavigableSet<Integer> backwardLoops) {
        Integer res;
        if (eligible == null) {
            eligible = new LinkedList<Integer>(alignment.keySet());
        }
        Map<Integer, Integer> alignK1 = SequenceFunctionRefiner.applyAlignmentAndCheckCycles(alignment, k - 1, eligible);
        Iterator<Integer> eligibleIt = eligible.iterator();
        while (eligibleIt.hasNext()) {
            res = eligibleIt.next();
            if (!alignK1.containsKey(res)) {
                eligibleIt.remove();
                continue;
            }
            Integer k1 = alignK1.get(res);
            if (k1 == null) {
                eligibleIt.remove();
                continue;
            }
            Double score = scores.get(res);
            if (score == null || score <= 0.0) {
                eligibleIt.remove();
                if (res <= alignment.get(res)) {
                    forwardLoops.add(res);
                    continue;
                }
                backwardLoops.add(res);
                continue;
            }
            Double scoreK1 = scores.get(k1);
            if (scoreK1 != null && !(scoreK1 <= 0.0)) continue;
            eligibleIt.remove();
        }
        eligibleIt = eligible.iterator();
        while (eligibleIt.hasNext()) {
            res = eligibleIt.next();
            Integer src = alignK1.get(res);
            if (src >= res) continue;
            Integer a = forwardLoops.floor(src);
            Integer b = forwardLoops.higher(src);
            if (a != null && alignment.get(a) > res) {
                eligibleIt.remove();
                continue;
            }
            if (b == null || alignment.get(b) >= res) continue;
            eligibleIt.remove();
        }
        return eligible;
    }

    private static Map<Integer, Integer> applyAlignmentAndCheckCycles(Map<Integer, Integer> alignmentMap, int k, List<Integer> eligible) {
        Integer pre;
        int i;
        ArrayList<Integer> preimage = new ArrayList<Integer>(alignmentMap.keySet());
        ArrayList<Integer> image = new ArrayList<Integer>(preimage);
        for (int n = 1; n <= k; ++n) {
            for (i = 0; i < image.size(); ++i) {
                pre = (Integer)image.get(i);
                Integer post = pre == null ? null : alignmentMap.get(pre);
                image.set(i, post);
                if (post == null || !post.equals(preimage.get(i))) continue;
                eligible.remove(preimage.get(i));
            }
        }
        HashMap<Integer, Integer> imageMap = new HashMap<Integer, Integer>(alignmentMap.size());
        for (i = 0; i < preimage.size(); ++i) {
            pre = (Integer)preimage.get(i);
            Integer postK = (Integer)image.get(i);
            imageMap.put(pre, postK);
        }
        return imageMap;
    }

    private static Map<Integer, Double> initializeScores(Map<Integer, Integer> alignment, Map<Integer, Double> scores, int k) {
        if (scores == null) {
            scores = new HashMap<Integer, Double>(alignment.size());
        } else {
            scores.clear();
        }
        Map<Integer, Integer> alignK = AlignmentTools.applyAlignment(alignment, k);
        int maxPre = Integer.MIN_VALUE;
        int minPre = Integer.MAX_VALUE;
        for (Integer pre : alignment.keySet()) {
            if (pre > maxPre) {
                maxPre = pre;
            }
            if (pre >= minPre) continue;
            minPre = pre;
        }
        for (Integer pre : alignment.keySet()) {
            Integer image = alignK.get(pre);
            double score = SequenceFunctionRefiner.scoreAbsError(pre, image, minPre, maxPre);
            scores.put(pre, score);
        }
        return scores;
    }

    private static double scoreAbsError(Integer pre, Integer image, int minPre, int maxPre) {
        double error = image == null ? Double.POSITIVE_INFINITY : (double)Math.abs(pre - image);
        if (error > 0.0) {
            error += (double)(pre - minPre) / (double)(1 + maxPre - minPre);
        }
        return error;
    }

    private static AFPChain partitionAFPchain(AFPChain afpChain, Atom[] ca1, Atom[] ca2, int order) throws StructureException {
        int i;
        int su;
        int[][][] newAlgn = new int[order][][];
        int repeatLen = afpChain.getOptLength() / order;
        ArrayList<Integer> alignedRes = new ArrayList<Integer>();
        for (su = 0; su < afpChain.getBlockNum(); ++su) {
            for (i = 0; i < afpChain.getOptLen()[su]; ++i) {
                alignedRes.add(afpChain.getOptAln()[su][0][i]);
            }
        }
        for (su = 0; su < order; ++su) {
            newAlgn[su] = new int[2][];
            newAlgn[su][0] = new int[repeatLen];
            newAlgn[su][1] = new int[repeatLen];
            for (i = 0; i < repeatLen; ++i) {
                newAlgn[su][0][i] = (Integer)alignedRes.get(repeatLen * su + i);
                newAlgn[su][1][i] = (Integer)alignedRes.get((repeatLen * (su + 1) + i) % alignedRes.size());
            }
        }
        return AlignmentTools.replaceOptAln(newAlgn, afpChain, ca1, ca2);
    }
}

