/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.xtal;

import java.io.Serializable;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3i;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.xtal.SpaceGroup;
import org.biojava.nbio.structure.xtal.TransformType;

public class CrystalTransform
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Matrix4d IDENTITY = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    private final SpaceGroup sg;
    private int transformId;
    private Matrix4d matTransform;
    private Point3i crystalTranslation;

    public CrystalTransform(SpaceGroup sg) {
        this.sg = sg;
        this.transformId = 0;
        this.matTransform = (Matrix4d)IDENTITY.clone();
        this.crystalTranslation = new Point3i(0, 0, 0);
    }

    public CrystalTransform(SpaceGroup sg, int transformId) {
        this.sg = sg;
        this.transformId = transformId;
        if (sg == null && transformId == 0) {
            this.matTransform = (Matrix4d)IDENTITY.clone();
        } else {
            if (sg == null) {
                throw new IllegalArgumentException("Space Group cannot be null if transformId!=0");
            }
            this.matTransform = (Matrix4d)sg.getTransformation(transformId).clone();
        }
        this.crystalTranslation = new Point3i(0, 0, 0);
    }

    public CrystalTransform(CrystalTransform transform) {
        this.sg = transform.sg;
        this.transformId = transform.transformId;
        this.matTransform = new Matrix4d(transform.matTransform);
        this.crystalTranslation = new Point3i((Tuple3i)transform.crystalTranslation);
    }

    public Matrix4d getMatTransform() {
        return this.matTransform;
    }

    public void setMatTransform(Matrix4d matTransform) {
        this.matTransform = matTransform;
    }

    public Point3i getCrystalTranslation() {
        return this.crystalTranslation;
    }

    public void translate(Point3i translation) {
        this.matTransform.m03 += (double)translation.x;
        this.matTransform.m13 += (double)translation.y;
        this.matTransform.m23 += (double)translation.z;
        this.crystalTranslation.add((Tuple3i)translation);
    }

    public boolean isEquivalent(CrystalTransform other) {
        Matrix4d mul = new Matrix4d();
        mul.mul(this.matTransform, other.matTransform);
        return mul.epsilonEquals(IDENTITY, 1.0E-4);
    }

    public boolean isPureCrystalTranslation() {
        return this.transformId == 0 && (this.crystalTranslation.x != 0 || this.crystalTranslation.y != 0 || this.crystalTranslation.z != 0);
    }

    public boolean isIdentity() {
        return this.transformId == 0 && this.crystalTranslation.x == 0 && this.crystalTranslation.y == 0 && this.crystalTranslation.z == 0;
    }

    public boolean isPureTranslation() {
        if (this.isPureCrystalTranslation()) {
            return true;
        }
        return SpaceGroup.deltaComp(this.matTransform.m00, 1.0, 1.0E-7) && SpaceGroup.deltaComp(this.matTransform.m01, 0.0, 1.0E-7) && SpaceGroup.deltaComp(this.matTransform.m02, 0.0, 1.0E-7) && SpaceGroup.deltaComp(this.matTransform.m10, 0.0, 1.0E-7) && SpaceGroup.deltaComp(this.matTransform.m11, 1.0, 1.0E-7) && SpaceGroup.deltaComp(this.matTransform.m12, 0.0, 1.0E-7) && SpaceGroup.deltaComp(this.matTransform.m20, 0.0, 1.0E-7) && SpaceGroup.deltaComp(this.matTransform.m21, 0.0, 1.0E-7) && SpaceGroup.deltaComp(this.matTransform.m22, 1.0, 1.0E-7) && (Math.abs(this.matTransform.m03 - 0.0) > 1.0E-7 || Math.abs(this.matTransform.m13 - 0.0) > 1.0E-7 || Math.abs(this.matTransform.m23 - 0.0) > 1.0E-7);
    }

    public boolean isFractionalTranslation() {
        return Math.abs(this.matTransform.m03 - (double)this.crystalTranslation.x) > 1.0E-7 || Math.abs(this.matTransform.m13 - (double)this.crystalTranslation.y) > 1.0E-7 || Math.abs(this.matTransform.m23 - (double)this.crystalTranslation.z) > 1.0E-7;
    }

    public boolean isRotation() {
        if (this.sg == null) {
            return false;
        }
        return this.sg.getAxisFoldType(this.transformId) > 1;
    }

    public TransformType getTransformType() {
        if (this.sg == null) {
            return TransformType.AU;
        }
        int foldType = this.sg.getAxisFoldType(this.transformId);
        boolean isScrewOrGlide = false;
        Vector3d translScrewComponent = this.getTranslScrewComponent();
        if (Math.abs(translScrewComponent.x - 0.0) > 1.0E-7 || Math.abs(translScrewComponent.y - 0.0) > 1.0E-7 || Math.abs(translScrewComponent.z - 0.0) > 1.0E-7) {
            isScrewOrGlide = true;
        }
        if (foldType > 1) {
            if (isScrewOrGlide) {
                switch (foldType) {
                    case 2: {
                        return TransformType.TWOFOLDSCREW;
                    }
                    case 3: {
                        return TransformType.THREEFOLDSCREW;
                    }
                    case 4: {
                        return TransformType.FOURFOLDSCREW;
                    }
                    case 6: {
                        return TransformType.SIXFOLDSCREW;
                    }
                }
                throw new NullPointerException("This transformation did not fall into any of the known types! This is most likely a bug.");
            }
            switch (foldType) {
                case 2: {
                    return TransformType.TWOFOLD;
                }
                case 3: {
                    return TransformType.THREEFOLD;
                }
                case 4: {
                    return TransformType.FOURFOLD;
                }
                case 6: {
                    return TransformType.SIXFOLD;
                }
            }
            throw new NullPointerException("This transformation did not fall into any of the known types! This is most likely a bug.");
        }
        if (foldType < 0) {
            switch (foldType) {
                case -1: {
                    return TransformType.ONEBAR;
                }
                case -2: {
                    if (isScrewOrGlide) {
                        return TransformType.GLIDE;
                    }
                    return TransformType.TWOBAR;
                }
                case -3: {
                    return TransformType.THREEBAR;
                }
                case -4: {
                    return TransformType.FOURBAR;
                }
                case -6: {
                    return TransformType.SIXBAR;
                }
            }
            throw new NullPointerException("This transformation did not fall into any of the known types! This is most likely a bug.");
        }
        if (this.isIdentity()) {
            return TransformType.AU;
        }
        if (this.isPureCrystalTranslation()) {
            return TransformType.XTALTRANSL;
        }
        if (this.isFractionalTranslation()) {
            return TransformType.CELLTRANSL;
        }
        throw new NullPointerException("This transformation did not fall into any of the known types! This is most likely a bug.");
    }

    public Vector3d getTranslScrewComponent() {
        return CrystalTransform.getTranslScrewComponent(this.matTransform);
    }

    public int getTransformId() {
        return this.transformId;
    }

    public void setTransformId(int transformId) {
        this.transformId = transformId;
    }

    public String toString() {
        return String.format("[%2d-(%s)]", this.transformId, this.toXYZString());
    }

    public String toXYZString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            boolean emptyRow = true;
            double coef = this.matTransform.getElement(i, 0);
            if (Math.abs(coef) > 1.0E-6) {
                if (Math.abs(Math.abs(coef) - 1.0) < 1.0E-6) {
                    if (coef < 0.0) {
                        str.append("-");
                    }
                } else {
                    str.append(this.formatCoef(coef));
                    str.append("*");
                }
                str.append("x");
                emptyRow = false;
            }
            if (Math.abs(coef = this.matTransform.getElement(i, 1)) > 1.0E-6) {
                if (Math.abs(Math.abs(coef) - 1.0) < 1.0E-6) {
                    if (coef < 0.0) {
                        str.append("-");
                    } else if (!emptyRow) {
                        str.append("+");
                    }
                } else {
                    if (!emptyRow && coef > 0.0) {
                        str.append("+");
                    }
                    str.append(this.formatCoef(coef));
                    str.append("*");
                }
                str.append("y");
                emptyRow = false;
            }
            if (Math.abs(coef = this.matTransform.getElement(i, 2)) > 1.0E-6) {
                if (Math.abs(Math.abs(coef) - 1.0) < 1.0E-6) {
                    if (coef < 0.0) {
                        str.append("-");
                    } else if (!emptyRow) {
                        str.append("+");
                    }
                } else {
                    if (!emptyRow && coef > 0.0) {
                        str.append("+");
                    }
                    str.append(this.formatCoef(coef));
                    str.append("*");
                }
                str.append("z");
                emptyRow = false;
            }
            if (Math.abs(coef = this.matTransform.getElement(i, 3)) > 1.0E-6) {
                if (!emptyRow && coef > 0.0) {
                    str.append("+");
                }
                str.append(this.formatCoef(coef));
            }
            if (i >= 2) continue;
            str.append(",");
        }
        return str.toString();
    }

    private String formatCoef(double coef) {
        double tol = 1.0E-6;
        if (Math.abs(coef) < tol) {
            return "0";
        }
        long num = Math.round(coef);
        if (Math.abs((double)num - coef) < tol) {
            return Long.toString(num);
        }
        for (int denom = 2; denom < 12; ++denom) {
            num = Math.round(coef * (double)denom);
            if (!((double)num - coef * (double)denom < tol)) continue;
            return String.format("%d/%d", num, denom);
        }
        return String.format("%.3f", coef);
    }

    public static Vector3d getTranslScrewComponent(Matrix4d m) {
        int foldType = SpaceGroup.getRotAxisType(m);
        Vector3d transl = null;
        Matrix3d W = new Matrix3d(m.m00, m.m01, m.m02, m.m10, m.m11, m.m12, m.m20, m.m21, m.m22);
        if (foldType >= 0) {
            Matrix3d Y = new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
            Matrix3d Wk = new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
            for (int k = 0; k < foldType; ++k) {
                Wk.mul(W);
                if (k == foldType - 1) continue;
                Y.add(Wk);
            }
            transl = new Vector3d(m.m03, m.m13, m.m23);
            Y.transform((Tuple3d)transl);
            transl.scale(1.0 / (double)foldType);
        } else if (foldType == -2) {
            Matrix3d Y = new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
            Y.add(W);
            transl = new Vector3d(m.m03, m.m13, m.m23);
            Y.transform((Tuple3d)transl);
            transl.scale(0.5);
        } else {
            transl = new Vector3d(0.0, 0.0, 0.0);
        }
        return transl;
    }
}

