/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.utilities.ols.web.service.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Annotation {
    public Map<String, List<String>> annotation = new HashMap<String, List<String>>();

    @JsonAnyGetter
    public Map<String, List<String>> any() {
        return this.annotation;
    }

    @JsonAnySetter
    public void set(String name, String[] value) {
        this.annotation.put(name, Arrays.asList(value));
    }

    public boolean hasUnknownProperties() {
        return !this.annotation.isEmpty();
    }

    public boolean containsAnnotation(String annotationType) {
        return annotationType != null && this.annotation.size() != 0 && this.annotation.containsKey(annotationType);
    }

    public List<String> getAnnotation(String annotationType) {
        if (annotationType == null || this.annotation.size() == 0 || !this.annotation.containsKey(annotationType)) {
            return null;
        }
        return this.annotation.get(annotationType);
    }

    public boolean containsCrossReference(String crossReferenceType) {
        return crossReferenceType != null && this.annotation.size() != 0 && this.containsAnnotation(AnnotationType.DATABASE_CROSS_REFERENCE.getValue()) && this.containsCrossReference(crossReferenceType, this.annotation.get(AnnotationType.DATABASE_CROSS_REFERENCE.getValue()));
    }

    public String getCrossReferenceValue(String crossReferenceType) {
        if (this.containsCrossReference(crossReferenceType)) {
            for (String annotation : this.annotation.get(AnnotationType.DATABASE_CROSS_REFERENCE.getValue())) {
                if (!annotation.toUpperCase().contains(crossReferenceType.toUpperCase()) || annotation.split(":").length != 2) continue;
                return annotation.split(":")[1];
            }
        }
        return null;
    }

    private boolean containsCrossReference(String crossReferenceType, List<String> annotations) {
        for (String annotation : annotations) {
            if (!annotation.toUpperCase().contains(crossReferenceType.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public Map<String, List<String>> getAnnotation() {
        return this.annotation;
    }

    public static enum AnnotationType {
        DATABASE_CROSS_REFERENCE("database_cross_reference");

        String value;

        private AnnotationType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

