/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.utilities.ols.web.service.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Annotation;
import uk.ac.ebi.pride.utilities.ols.web.service.model.ITerm;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Identifier;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Link;
import uk.ac.ebi.pride.utilities.ols.web.service.model.OBOSynonym;
import uk.ac.ebi.pride.utilities.ols.web.service.model.OBOXRef;
import uk.ac.ebi.pride.utilities.ols.web.service.model.OboDefinitionCitation;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Term
implements Comparable,
ITerm {
    @JsonProperty(value="iri")
    private Identifier iri;
    @JsonProperty(value="label")
    private String label;
    @JsonProperty(value="description")
    private String[] description;
    @JsonProperty(value="annotation")
    private Annotation annotation;
    @JsonProperty(value="synonyms")
    private String[] synonyms;
    @JsonProperty(value="ontology_name")
    private String ontologyName;
    @JsonProperty(value="score")
    private String score;
    @JsonProperty(value="ontology_prefix")
    private String ontologyPrefix;
    @JsonProperty(value="ontology_iri")
    private String ontologyIri;
    @JsonProperty(value="is_defining_ontology")
    private boolean definedOntology;
    @JsonProperty(value="has_children")
    private boolean hasChildren;
    @JsonProperty(value="is_root")
    private boolean root;
    @JsonProperty(value="short_form")
    private Identifier shortForm;
    @JsonProperty(value="obo_id")
    private Identifier oboId;
    @JsonProperty(value="obo_definition_citation")
    private OboDefinitionCitation[] oboDefinitionCitation;
    @JsonProperty(value="_links")
    private Link link;
    @JsonProperty(value="obo_xref")
    private OBOXRef[] oboXRefs;
    @JsonProperty(value="obo_synonym")
    private OBOSynonym[] oboSynonyms;

    public Term() {
    }

    public Term(Identifier iri, String label, String[] description, Identifier shortForm, Identifier oboId, String ontologyName, String score, String ontologyIri, boolean definedOntology, OboDefinitionCitation[] oboDefinitionCitation) {
        this.iri = iri;
        this.label = label;
        this.description = description;
        this.shortForm = shortForm;
        this.oboId = oboId;
        this.ontologyName = ontologyName;
        this.score = score;
        this.ontologyIri = ontologyIri;
        this.definedOntology = definedOntology;
        this.oboDefinitionCitation = oboDefinitionCitation;
    }

    public Term(Identifier iri, String label, String[] description, Identifier shortForm, Identifier oboId, String ontologyName, String score, String ontologyIri, boolean definedOntology, OboDefinitionCitation[] oboDefinitionCitation, Annotation annotation) {
        this.iri = iri;
        this.label = label;
        this.description = description;
        this.shortForm = shortForm;
        this.oboId = oboId;
        this.ontologyName = ontologyName;
        this.score = score;
        this.ontologyIri = ontologyIri;
        this.definedOntology = definedOntology;
        this.oboDefinitionCitation = oboDefinitionCitation;
        this.annotation = annotation;
    }

    @Override
    public Identifier getIri() {
        return this.iri;
    }

    public void setIri(String iri) {
        this.iri = new Identifier(iri, Identifier.IdentifierType.IRI);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String[] getDescription() {
        return this.description;
    }

    public void setDescription(String[] description) {
        this.description = description;
    }

    public String[] getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(String[] synonyms) {
        this.synonyms = synonyms;
    }

    @Override
    public String getOntologyName() {
        return this.ontologyName;
    }

    public void setOntologyName(String ontologyName) {
        this.ontologyName = ontologyName;
    }

    public String getScore() {
        return this.score;
    }

    public void setScore(String score) {
        this.score = score;
    }

    public String getOntologyPrefix() {
        return this.ontologyPrefix;
    }

    public void setOntologyPrefix(String ontologyPrefix) {
        this.ontologyPrefix = ontologyPrefix;
    }

    @Override
    public String getOntologyIri() {
        return this.ontologyIri;
    }

    public void setOntologyIri(String ontologyIri) {
        this.ontologyIri = ontologyIri;
    }

    public boolean isDefinedOntology() {
        return this.definedOntology;
    }

    public void setDefinedOntology(boolean definedOntology) {
        this.definedOntology = definedOntology;
    }

    public boolean isHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public Identifier getShortForm() {
        return this.shortForm;
    }

    public void setShortForm(String shortForm) {
        this.shortForm = new Identifier(shortForm, Identifier.IdentifierType.OWL);
    }

    public Identifier getTermOBOId() {
        return this.oboId;
    }

    public void setOboId(String oboId) {
        this.oboId = new Identifier(oboId, Identifier.IdentifierType.OBO);
    }

    public Link getLink() {
        return this.link;
    }

    public void setLink(Link link) {
        this.link = link;
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public Identifier getGlobalId() {
        return this.oboId != null ? this.oboId : this.shortForm;
    }

    public OBOXRef[] getOboXRefs() {
        return this.oboXRefs;
    }

    public void setOboXRefs(OBOXRef[] oboXRefs) {
        this.oboXRefs = oboXRefs;
    }

    public OboDefinitionCitation[] getOboDefinitionCitation() {
        return this.oboDefinitionCitation;
    }

    public void setOboDefinitionCitation(OboDefinitionCitation[] oboDefinitionCitation) {
        this.oboDefinitionCitation = oboDefinitionCitation;
    }

    public boolean containsXref(String annotationType) {
        if (this.oboXRefs != null && this.oboXRefs.length > 0) {
            for (OBOXRef oboRef : this.oboXRefs) {
                if (oboRef == null || oboRef.getId() == null || !oboRef.getDatabase().toUpperCase().contains(annotationType.toUpperCase())) continue;
                return true;
            }
        }
        return false;
    }

    public String getXRefValue(String annotationType) {
        if (this.oboXRefs != null && this.oboXRefs.length > 0) {
            for (OBOXRef oboRef : this.oboXRefs) {
                if (oboRef == null || oboRef.getDatabase() == null || !oboRef.getDatabase().toUpperCase().contains(annotationType.toUpperCase())) continue;
                return oboRef.getDescription();
            }
        }
        return null;
    }

    public Map<String, String> getOboSynonyms() {
        HashMap<String, String> synonyms = new HashMap<String, String>();
        if (this.oboSynonyms != null) {
            for (OBOSynonym synonym : this.oboSynonyms) {
                if (synonym.getName() == null) continue;
                synonyms.put(synonym.getName(), synonym.getType());
            }
        }
        return synonyms;
    }

    public int compareTo(Object o) {
        Term newTerm = (Term)o;
        if (this.oboId != null && this.oboId.getIdentifier() != null && newTerm != null && newTerm.getTermOBOId() != null && newTerm.getTermOBOId().getIdentifier() != null) {
            return this.oboId.getIdentifier().compareTo(newTerm.getTermOBOId().getIdentifier());
        }
        if (this.shortForm != null && this.shortForm.getIdentifier() != null && newTerm != null && newTerm.getShortForm() != null && newTerm.getTermOBOId().getIdentifier() != null) {
            return this.oboId.getIdentifier().compareTo(newTerm.getTermOBOId().getIdentifier());
        }
        if (this.iri != null && this.iri.getIdentifier() != null && newTerm != null && newTerm.getIri() != null && newTerm.getIri().getIdentifier() != null) {
            return this.iri.getIdentifier().compareTo(newTerm.getIri().getIdentifier());
        }
        return 0;
    }

    public String toString() {
        return "Term{iri=" + this.iri + ", label='" + this.label + '\'' + ", oboId=" + this.oboId + ", shortForm=" + this.shortForm + ", description=" + Arrays.toString(this.description) + '}';
    }

    @Override
    public String getName() {
        return this.getLabel();
    }

    @Override
    public Identifier getShortName() {
        return this.shortForm;
    }

    @Override
    public Identifier getOboId() {
        return this.oboId;
    }
}

