/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.functions.Func1;

public final class OperatorFromTransformer<R, T>
implements Observable.Operator<R, T> {
    private final Func1<? super Observable<T>, ? extends Observable<R>> operation;

    public static <R, T> Observable.Operator<R, T> toOperator(Func1<? super Observable<T>, ? extends Observable<R>> operation) {
        return new OperatorFromTransformer<R, T>(operation);
    }

    public OperatorFromTransformer(Func1<? super Observable<T>, ? extends Observable<R>> operation) {
        this.operation = operation;
    }

    public Subscriber<? super T> call(Subscriber<? super R> subscriber) {
        ParentSubscriber parent = new ParentSubscriber();
        Observable middle = Observable.create(new ForwarderOnSubscribe(parent));
        subscriber.add(parent);
        ((Observable)this.operation.call((Object)middle)).unsafeSubscribe(subscriber);
        return parent;
    }

    static final class ParentSubscriber<T>
    extends Subscriber<T> {
        volatile Subscriber<? super T> subscriber;

        ParentSubscriber() {
        }

        void requestMore(long n) {
            this.request(n);
        }

        public void onCompleted() {
            this.subscriber.onCompleted();
        }

        public void onError(Throwable e) {
            this.subscriber.onError(e);
        }

        public void onNext(T t) {
            this.subscriber.onNext(t);
        }
    }

    static final class ForwarderOnSubscribe<T>
    implements Observable.OnSubscribe<T> {
        private final ParentSubscriber<T> parent;

        ForwarderOnSubscribe(ParentSubscriber<T> parent) {
            this.parent = parent;
        }

        public void call(Subscriber<? super T> sub) {
            this.parent.subscriber = sub;
            sub.setProducer(new Producer(){

                public void request(long n) {
                    ForwarderOnSubscribe.this.parent.requestMore(n);
                }
            });
        }
    }
}

