/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.task.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.AbstractTask;
import uk.ac.ebi.pride.toolsuite.ols.dialog.util.Util;
import uk.ac.ebi.pride.utilities.ols.web.service.client.OLSClient;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Identifier;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Ontology;

public class GetOntologiesTask
extends AbstractTask {
    public static Logger logger = LoggerFactory.getLogger(GetOntologiesTask.class);
    String ontologyToSelect = "";
    private static String NAME_TASK = "Get All Ontologies in OLS";

    public GetOntologiesTask(OLSDialog olsDialog, OLSClient olsClient) {
        super(NAME_TASK, olsDialog, olsClient);
    }

    @Override
    protected Object doInBackground() throws Exception {
        Vector<String> ontologyNamesAndKeys = new Vector<String>();
        this.olsDialog.setPreselectedNames2Ids(new HashMap<String, Identifier>());
        List<Ontology> ontologies = this.olsClient.getOntologies();
        ontologies = Util.refineOntologyNames(ontologies);
        for (Ontology ontology : ontologies) {
            String key = ontology.getConfig().getPreferredPrefix();
            String temp = ontology.getName() + " [" + key + "]";
            if (this.olsDialog.getPreselectedOntologies().isEmpty()) {
                ontologyNamesAndKeys.add(temp);
            } else if (this.olsDialog.getPreselectedOntologies().keySet().contains(key.toLowerCase()) && this.olsDialog.getPreselectedOntologies().get(key.toUpperCase()) == null) {
                ontologyNamesAndKeys.add(temp);
            }
            if (!this.olsDialog.getSelectedOntology().equalsIgnoreCase(temp) && !this.olsDialog.getSelectedOntology().equalsIgnoreCase(key)) continue;
            this.ontologyToSelect = temp;
        }
        if (!this.olsDialog.getPreselectedOntologies().isEmpty() && this.olsDialog.getPreselectedOntologies().size() != ontologyNamesAndKeys.size()) {
            logger.error("Warning: One or more of your preselected ontologies have not been found in OLS");
        }
        Collections.sort(ontologyNamesAndKeys);
        return ontologyNamesAndKeys;
    }

    @Override
    protected void done() {
        Vector ontologyNamesAndKeys = null;
        try {
            ontologyNamesAndKeys = (Vector)this.get();
            if (!this.olsDialog.isOnlyListPreselectedOntologies()) {
                ontologyNamesAndKeys.add(0, "-- Search in All Ontologies available in the OLS registry --");
                if (this.olsDialog.getPreselectedOntologies().size() > 1) {
                    ontologyNamesAndKeys.add(1, "-- Search in these preselected Ontologies --");
                }
            }
            this.olsDialog.getOntologyJComboBox().setModel(new DefaultComboBoxModel(ontologyNamesAndKeys));
            this.olsDialog.getOntologyJComboBox().setSelectedItem(this.ontologyToSelect);
            this.olsDialog.setLastSelectedOntology((String)this.olsDialog.getOntologyJComboBox().getSelectedItem());
            this.olsDialog.hideOrShowNewtLinks();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.olsDialog, OLSDialog.DEFAULT_OLS_CONNECTION_ERROR, "Failed to Contact the OLS", 0);
            logger.error("Error when trying to access OLS: ");
        }
    }

    @Override
    protected void cancelled() {
    }

    protected void succeed(Object results) {
    }

    @Override
    protected void finished() {
    }

    @Override
    protected void interrupted(InterruptedException iex) {
    }
}

