/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.message.ThrowableHandler;
import uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager.NotificationDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager.StatusBarPanel;
import uk.ac.ebi.pride.toolsuite.ols.dialog.util.GUIUtils;

public class NotificationPanel
extends StatusBarPanel {
    private JDialog throwableMessageBoard;
    private JLabel errorLabel;

    public NotificationPanel(OLSDialog olsDialog) {
        super(24, true);
        this.setLayout(new BorderLayout());
        this.throwableMessageBoard = new NotificationDialog(olsDialog);
        this.throwableMessageBoard.setVisible(false);
        Icon icon = GUIUtils.loadIcon("icons/no_exception_notify.png");
        this.errorLabel = new JLabel(icon);
        this.errorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NotificationPanel.this.throwableMessageBoard.setVisible(true);
            }
        });
        this.add((Component)this.errorLabel, "Center");
        ThrowableHandler throwableHandler = olsDialog.getThrowableHandler();
        throwableHandler.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        List throwables;
        String eventName = evt.getPropertyName();
        if ("ADD_THROWABLE_PROP".equals(eventName)) {
            Icon icon = GUIUtils.loadIcon("icons/exception_notify.png");
            this.errorLabel.setIcon(icon);
        } else if ("REMOVE_THROWABLE_PROP".equals(eventName) && (throwables = (List)evt.getNewValue()).isEmpty()) {
            Icon icon = GUIUtils.loadIcon("icons/no_exception_notify.png");
            this.errorLabel.setIcon(icon);
        }
    }
}

