/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.AbstractTask;
import uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager.StatusBarPanel;
import uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager.TaskDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager.TaskManager;

public class TaskMonitorPanel
extends StatusBarPanel {
    private JProgressBar taskProgressBar;
    private JDialog taskProgressDialog;

    public TaskMonitorPanel(OLSDialog olsDialog) {
        super(0, true);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(250, 25));
        this.taskProgressDialog = new TaskDialog(olsDialog);
        this.taskProgressDialog.setVisible(false);
        this.taskProgressBar = new JProgressBar();
        this.taskProgressBar.setIndeterminate(true);
        this.taskProgressBar.setStringPainted(true);
        this.taskProgressBar.setToolTipText("Click to show/hide background tasks window");
        this.taskProgressBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TaskMonitorPanel.this.taskProgressDialog.setVisible(true);
            }
        });
        this.taskProgressBar.setVisible(false);
        this.add((Component)this.taskProgressBar, "Center");
        TaskManager taskMgr = olsDialog.getTaskManager();
        taskMgr.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String eventName = evt.getPropertyName();
        if ("add_new_task".equals(eventName)) {
            List newTasks = (List)evt.getNewValue();
            if (!newTasks.isEmpty()) {
                AbstractTask newTask = (AbstractTask)newTasks.get(newTasks.size() - 1);
                this.taskProgressBar.setString(newTask.getNameTask());
                this.taskProgressBar.setVisible(true);
            }
        } else if ("remove_new_task".equals(eventName)) {
            List newTasks = (List)evt.getNewValue();
            if (newTasks.isEmpty()) {
                this.taskProgressBar.setVisible(false);
            } else {
                AbstractTask newTask = (AbstractTask)newTasks.get(newTasks.size() - 1);
                this.taskProgressBar.setString(newTask.getNameTask());
            }
        }
    }
}

