/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.util;

import java.awt.Cursor;
import java.awt.GridLayout;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSDialog;
import uk.ac.ebi.pride.utilities.ols.web.service.model.ITerm;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Term;

public class TreeBrowser
extends JPanel
implements TreeSelectionListener,
TreeModelListener,
TreeExpansionListener {
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected JTree tree;
    private OLSDialog olsDialog;
    private static JScrollPane scrollPane;

    public TreeBrowser(OLSDialog parent) {
        super(new GridLayout(1, 0));
        this.olsDialog = parent;
        Term term = new Term(null, null, null, null, null, "Load Ontology to Browse", null, null, true, null);
        this.tree = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode(new TermNode((ITerm)term, null))));
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(this);
        scrollPane = new JScrollPane(this.tree);
        this.add(scrollPane);
    }

    public void scrollToTop() {
        scrollPane.getVerticalScrollBar().setValue(0);
        scrollPane.getHorizontalScrollBar().setValue(0);
    }

    public void initialize(String ontologyName) {
        Term term = new Term(null, null, null, null, null, ontologyName, null, null, false, null);
        this.rootNode = new DefaultMutableTreeNode(new TermNode((ITerm)term, null));
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeModel.addTreeModelListener(this);
        this.tree.addTreeExpansionListener(this);
        this.tree.setModel(this.treeModel);
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public void updateTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        TreePath path = new TreePath(root.getPath());
        this.tree.collapsePath(path);
        this.tree.expandPath(path);
    }

    public DefaultMutableTreeNode addNode(ITerm term) {
        TreePath parentPath = this.tree.getSelectionPath();
        DefaultMutableTreeNode parentNode = parentPath == null ? this.rootNode : (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        return this.addNode(parentNode, term, true);
    }

    public DefaultMutableTreeNode addNode(DefaultMutableTreeNode parent, ITerm term, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new TermNode(term));
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.olsDialog.setCursor(new Cursor(3));
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        int verticalScrollBarValue = scrollPane.getVerticalScrollBar().getValue();
        int horizontalScrollBarValue = scrollPane.getHorizontalScrollBar().getValue();
        TermNode nodeInfo = (TermNode)node.getUserObject();
        if (nodeInfo.getTerm() != null && nodeInfo.getTerm().getName() != null && !nodeInfo.getTerm().getName().equalsIgnoreCase("No Root Terms Defined!")) {
            if (node.isLeaf() && node.getAllowsChildren() && !this.olsDialog.loadChildren(node, nodeInfo.getTerm())) {
                node.setAllowsChildren(false);
            }
            scrollPane.getVerticalScrollBar().setValue(verticalScrollBarValue);
            scrollPane.getHorizontalScrollBar().setValue(horizontalScrollBarValue);
            this.olsDialog.loadMetaData(nodeInfo.getTerm(), OLSDialog.OLS_DIALOG_BROWSE_ONTOLOGY);
        } else if (nodeInfo.getTerm() != null && nodeInfo.getTerm().getName() == null && !nodeInfo.getTerm().getOntologyName().equalsIgnoreCase("No Root Terms Defined!")) {
            this.olsDialog.loadMetaOntologyData(nodeInfo.getTerm().getOntologyName(), OLSDialog.OLS_DIALOG_BROWSE_ONTOLOGY);
        } else {
            this.olsDialog.clearData(OLSDialog.OLS_DIALOG_BROWSE_ONTOLOGY, true, true);
        }
        this.olsDialog.setCursor(new Cursor(0));
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.olsDialog.setCursor(new Cursor(3));
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (currentNode.getChildCount() != 0) continue;
            TermNode nodeInfo = (TermNode)currentNode.getUserObject();
            this.olsDialog.addSecondLevelOfNodes(nodeInfo.getTerm(), this.olsDialog.getCurrentOntologyLabel(), currentNode);
        }
        this.olsDialog.setCursor(new Cursor(0));
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    private class TermNode {
        private ITerm term;
        private ITerm parentTerm;
        private String type;

        public void setTerm(ITerm term) {
            this.term = term;
        }

        public TermNode(ITerm term) {
            this.term = term;
        }

        public TermNode(ITerm term, ITerm parentTerm) {
            this.term = term;
            this.parentTerm = parentTerm;
        }

        public String getTermName() {
            return this.term.getName();
        }

        public String toString() {
            String nodeString = "";
            if (this.term != null && this.term.getGlobalId() != null) {
                nodeString = nodeString + StringUtils.capitalize((String)this.term.getName()) + " [ " + this.term.getGlobalId().getIdentifier().toUpperCase() + " ]";
            } else if (this.term != null && this.term.getGlobalId() == null && this.term.getName() != null) {
                nodeString = nodeString + this.term.getName();
            } else if (this.term != null && this.term.getOntologyName() != null) {
                nodeString = nodeString + this.term.getOntologyName().toString().toUpperCase();
            }
            return nodeString;
        }

        public ITerm getTerm() {
            return this.term;
        }

        public ITerm getParentTerm() {
            return this.parentTerm;
        }

        public void setParentTerm(Term parentTerm) {
            this.parentTerm = parentTerm;
        }
    }
}

