/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.sqlite4java;

import com.almworks.sqlite4java.Internal;
import com.almworks.sqlite4java.SQLiteController;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SWIGTYPE_p_sqlite3_blob;
import com.almworks.sqlite4java._SQLiteManual;
import com.almworks.sqlite4java._SQLiteSwigged;

public final class SQLiteBlob {
    private final String myName;
    private final boolean myWriteAccess;
    private SQLiteController myController;
    private SWIGTYPE_p_sqlite3_blob myHandle;
    private int myLength = -1;

    SQLiteBlob(SQLiteController controller, SWIGTYPE_p_sqlite3_blob handle, String dbname, String table, String column, long rowid, boolean writeAccess) {
        assert (controller != null);
        assert (handle != null);
        this.myController = controller;
        this.myHandle = handle;
        this.myWriteAccess = writeAccess;
        this.myName = dbname + "." + table + "." + column + ":" + rowid;
    }

    public void dispose() {
        if (this.myHandle == null) {
            return;
        }
        try {
            this.myController.validate();
        }
        catch (SQLiteException e) {
            Internal.recoverableError(this, "invalid dispose: " + e, true);
            return;
        }
        Internal.logFine(this, "disposing");
        this.myController.dispose(this);
        this.clear();
    }

    public boolean isDisposed() {
        return this.myHandle == null;
    }

    public int getSize() throws SQLiteException {
        this.myController.validate();
        if (this.myLength < 0) {
            this.myLength = _SQLiteSwigged.sqlite3_blob_bytes(this.handle());
        }
        return this.myLength;
    }

    public void read(int blobOffset, byte[] buffer, int offset, int length) throws SQLiteException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset + length > buffer.length) {
            throw new ArrayIndexOutOfBoundsException(buffer.length + " " + offset + " " + length);
        }
        this.myController.validate();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "read[" + blobOffset + "," + length + "]");
        }
        int rc = _SQLiteManual.sqlite3_blob_read(this.handle(), blobOffset, buffer, offset, length);
        this.myController.throwResult(rc, "read", this);
    }

    public void write(int blobOffset, byte[] buffer, int offset, int length) throws SQLiteException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset + length > buffer.length) {
            throw new ArrayIndexOutOfBoundsException(buffer.length + " " + offset + " " + length);
        }
        this.myController.validate();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "write[" + blobOffset + "," + length + "]");
        }
        int rc = _SQLiteManual.sqlite3_blob_write(this.handle(), blobOffset, buffer, offset, length);
        this.myController.throwResult(rc, "write", this);
    }

    public boolean isWriteAllowed() {
        return this.myWriteAccess;
    }

    public void reopen(long rowid) throws SQLiteException {
        this.myController.validate();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "reopen[" + rowid + "]");
        }
        int rc = _SQLiteSwigged.sqlite3_blob_reopen(this.handle(), rowid);
        this.myController.throwResult(rc, "reopen", this);
    }

    private SWIGTYPE_p_sqlite3_blob handle() throws SQLiteException {
        SWIGTYPE_p_sqlite3_blob handle = this.myHandle;
        if (handle == null) {
            throw new SQLiteException(-93, null);
        }
        return handle;
    }

    SWIGTYPE_p_sqlite3_blob blobHandle() {
        return this.myHandle;
    }

    void clear() {
        this.myHandle = null;
        this.myController = SQLiteController.getDisposed(this.myController);
        Internal.logFine(this, "cleared");
    }

    public String toString() {
        return "[" + this.myName + "]" + this.myController;
    }
}

