/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended;

import com.ximpleware.extended.IIntBuffer;
import java.util.ArrayList;

public class FastIntBuffer
implements IIntBuffer {
    private ArrayList bufferArrayList;
    private int capacity;
    private int pageSize;
    private int size;
    private int exp;
    private int r;

    public FastIntBuffer() {
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1024;
        this.exp = 10;
        this.r = 1023;
        this.bufferArrayList = new ArrayList();
    }

    public FastIntBuffer(int e) {
        if (e < 0) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1 << e;
        this.exp = e;
        this.r = this.pageSize - 1;
        this.bufferArrayList = new ArrayList();
    }

    public void append(int[] int_array) {
        int lastBufferIndex;
        int[] lastBuffer;
        if (int_array == null) {
            throw new NullPointerException();
        }
        if (this.bufferArrayList.size() == 0) {
            lastBuffer = new int[this.pageSize];
            this.bufferArrayList.add(lastBuffer);
            lastBufferIndex = 0;
            this.capacity = this.pageSize;
        } else {
            lastBufferIndex = Math.min(this.size >> this.exp, this.bufferArrayList.size() - 1);
            lastBuffer = (int[])this.bufferArrayList.get(lastBufferIndex);
        }
        if (this.size + int_array.length < this.capacity) {
            if (this.size + int_array.length < lastBufferIndex + 1 << this.exp) {
                System.arraycopy(int_array, 0, lastBuffer, this.size & this.r, int_array.length);
            } else {
                int z;
                int offset = this.pageSize - (this.size & this.r);
                System.arraycopy(int_array, 0, lastBuffer, this.size & this.r, offset);
                int l = int_array.length - offset;
                int k = l >> this.exp;
                for (z = 1; z <= k; ++z) {
                    System.arraycopy(int_array, offset, (int[])this.bufferArrayList.get(lastBufferIndex + z), 0, this.pageSize);
                    offset += this.pageSize;
                }
                System.arraycopy(int_array, offset, (int[])this.bufferArrayList.get(lastBufferIndex + z), 0, l & this.r);
            }
            this.size += int_array.length;
            return;
        }
        int n = (int_array.length + this.size >> this.exp) + ((int_array.length + this.size & this.r) > 0 ? 1 : 0) - (this.capacity >> this.exp);
        System.arraycopy(int_array, 0, lastBuffer, this.size & this.r, this.capacity - this.size);
        for (int i = 0; i < n; ++i) {
            int[] newBuffer = new int[this.pageSize];
            if (i < n - 1) {
                System.arraycopy(int_array, this.pageSize * i + this.capacity - this.size, newBuffer, 0, this.pageSize);
            } else {
                System.arraycopy(int_array, this.pageSize * i + this.capacity - this.size, newBuffer, 0, int_array.length + this.size - this.capacity - this.pageSize * i);
            }
            this.bufferArrayList.add(newBuffer);
        }
        this.size += int_array.length;
        this.capacity += n * this.pageSize;
    }

    public void append(int i) {
        int[] lastBuffer;
        if (this.bufferArrayList.size() == 0) {
            lastBuffer = new int[this.pageSize];
            this.bufferArrayList.add(lastBuffer);
            this.capacity = this.pageSize;
        } else {
            int lastBufferIndex = Math.min(this.size >> this.exp, this.bufferArrayList.size() - 1);
            lastBuffer = (int[])this.bufferArrayList.get(lastBufferIndex);
        }
        if (this.size + 1 <= this.capacity) {
            lastBuffer[this.size & this.r] = i;
            ++this.size;
        } else {
            int[] newBuffer = new int[this.pageSize];
            ++this.size;
            this.capacity += this.pageSize;
            this.bufferArrayList.add(newBuffer);
            newBuffer[0] = i;
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int[] getIntArray(int startingOffset, int len) {
        if (this.size <= 0 || startingOffset < 0) {
            throw new IllegalArgumentException();
        }
        if (startingOffset + len > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int[] result = new int[len];
        int first_index = startingOffset >> this.exp;
        int last_index = startingOffset + len >> this.exp;
        if ((startingOffset + len & this.r) == 0) {
            --last_index;
        }
        if (first_index == last_index) {
            System.arraycopy((int[])this.bufferArrayList.get(first_index), startingOffset & this.r, result, 0, len);
        } else {
            int int_array_offset = 0;
            for (int i = first_index; i <= last_index; ++i) {
                int[] currentChunk = (int[])this.bufferArrayList.get(i);
                if (i == first_index) {
                    System.arraycopy(currentChunk, startingOffset & this.r, result, 0, this.pageSize - (startingOffset & this.r));
                    int_array_offset += this.pageSize - (startingOffset & this.r);
                    continue;
                }
                if (i == last_index) {
                    System.arraycopy(currentChunk, 0, result, int_array_offset, len - int_array_offset);
                    continue;
                }
                System.arraycopy(currentChunk, 0, result, int_array_offset, this.pageSize);
                int_array_offset += this.pageSize;
            }
        }
        return result;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int intAt(int index) {
        if (index < 0 || index > this.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        int pageNum = index >> this.exp;
        int offset = index & this.r;
        return ((int[])this.bufferArrayList.get(pageNum))[offset];
    }

    public void modifyEntry(int index, int newValue) {
        if (index < 0 || index > this.size - 1) {
            throw new IndexOutOfBoundsException();
        }
        ((int[])this.bufferArrayList.get((int)(index >> this.exp)))[index & this.r] = newValue;
    }

    public int size() {
        return this.size;
    }

    public boolean resize(int newSz) {
        if (newSz <= this.capacity && newSz >= 0) {
            this.size = newSz;
            return true;
        }
        return false;
    }

    public int[] toIntArray() {
        if (this.size > 0) {
            int s = this.size;
            int[] resultArray = new int[this.size];
            int array_offset = 0;
            int i = 0;
            while (s > 0) {
                System.arraycopy((int[])this.bufferArrayList.get(i), 0, resultArray, array_offset, s < this.pageSize ? s : this.pageSize);
                s -= this.pageSize;
                array_offset += this.pageSize;
                ++i;
            }
            return resultArray;
        }
        return null;
    }

    public void clear() {
        this.size = 0;
    }
}

