/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.brucker.timstof.converter;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.github.mzdb4s.db.model.CommonInstrumentParams;
import com.github.mzdb4s.db.model.InstrumentConfiguration;
import com.github.mzdb4s.db.model.MzDbHeader;
import com.github.mzdb4s.db.model.MzDbMetaData;
import com.github.mzdb4s.db.model.ProcessingMethod;
import com.github.mzdb4s.db.model.Run;
import com.github.mzdb4s.db.model.Sample;
import com.github.mzdb4s.db.model.Software;
import com.github.mzdb4s.db.model.SourceFile;
import com.github.mzdb4s.db.model.SpectrumXmlMetaData;
import com.github.mzdb4s.db.model.params.Activation;
import com.github.mzdb4s.db.model.params.ComponentList;
import com.github.mzdb4s.db.model.params.IsolationWindowParamTree;
import com.github.mzdb4s.db.model.params.ParamTree;
import com.github.mzdb4s.db.model.params.ScanList;
import com.github.mzdb4s.db.model.params.SelectedIon;
import com.github.mzdb4s.db.model.params.SelectedIonList;
import com.github.mzdb4s.db.model.params.SourceComponent;
import com.github.mzdb4s.db.model.params.param.CVParam;
import com.github.mzdb4s.db.model.params.param.PsiMsCV;
import com.github.mzdb4s.db.model.params.param.UserParam;
import com.github.mzdb4s.io.writer.MzDbWriter;
import com.github.mzdb4s.msdata.DataEncoding;
import com.github.mzdb4s.msdata.DataMode;
import com.github.mzdb4s.msdata.DefaultBBSizes$;
import com.github.mzdb4s.msdata.ISpectrumData;
import com.github.mzdb4s.msdata.PeakEncoding;
import com.github.mzdb4s.msdata.SpectrumData;
import com.github.mzdb4s.msdata.SpectrumHeader;
import com.github.sqlite4s.ISQLiteFactory;
import com.github.sqlite4s.SQLiteFactory$;
import fr.profi.brucker.timstof.converter.ConverterArguments;
import fr.profi.brucker.timstof.converter.SpectrumGeneratingMethod;
import fr.profi.brucker.timstof.io.TimstofReader;
import fr.profi.brucker.timstof.model.AbstractTimsFrame;
import fr.profi.brucker.timstof.model.Precursor;
import fr.profi.brucker.timstof.model.Spectrum;
import fr.profi.brucker.timstof.model.TimsPASEFFrame;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.File;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters;

public class Timstof2Mzdb {
    private static final Logger LOG = LoggerFactory.getLogger(Timstof2Mzdb.class);
    static String filepath = "C:\\vero\\DEV\\TimsTof\\example_data\\20200527_essais\\2022002-1_eColi-10ng-30min_Slot1-10_1_304.d";
    Option noneOp = None$.MODULE$;
    private File m_ttFile;
    private SpectrumGeneratingMethod m_ms1Method;
    private long m_fileHdl;
    private TimstofReader m_ttReader;
    private Int2IntMap m_spectra2FrameIndex;
    private Int2IntMap m_frame2FirstSpectraIndex;
    private Int2IntMap m_frame2ReadSpectraCount;
    private Int2ObjectMap<AbstractTimsFrame> m_frameById;
    private Int2ObjectMap<Precursor> m_precursorByIds;
    DataEncoding m_profileDataEnconding;
    DataEncoding m_centroidDataEnconding;
    DataEncoding m_fittedDataEnconding;

    public Timstof2Mzdb(File ttFile, SpectrumGeneratingMethod ms1Method) {
        this.m_ttFile = ttFile;
        this.m_ms1Method = ms1Method;
        this.m_ttReader = TimstofReader.getTimstofReader();
        this.m_fileHdl = this.m_ttReader.openTimstofFile(this.m_ttFile);
        this.initFramesData();
        this.m_profileDataEnconding = new DataEncoding(-1, DataMode.PROFILE(), PeakEncoding.HIGH_RES_PEAK(), "none", ByteOrder.LITTLE_ENDIAN);
        this.m_centroidDataEnconding = new DataEncoding(-1, DataMode.CENTROID(), PeakEncoding.HIGH_RES_PEAK(), "none", ByteOrder.LITTLE_ENDIAN);
        this.m_fittedDataEnconding = new DataEncoding(-1, DataMode.FITTED(), PeakEncoding.HIGH_RES_PEAK(), "none", ByteOrder.LITTLE_ENDIAN);
    }

    private void closeFile() {
        this.m_ttReader.closeTimstofFile(this.m_fileHdl);
    }

    private void initFramesData() {
        long start = System.currentTimeMillis();
        List<AbstractTimsFrame> frames = this.m_ttReader.getFullTimsFrames(this.m_fileHdl);
        Collections.sort(frames);
        int spectrumIndex = 1;
        this.m_spectra2FrameIndex = new Int2IntOpenHashMap();
        this.m_frame2FirstSpectraIndex = new Int2IntOpenHashMap(frames.size() * 4 / 3 + 1);
        this.m_frameById = new Int2ObjectOpenHashMap(frames.size() * 4 / 3 + 1);
        for (AbstractTimsFrame tf : frames) {
            int nbrSpectrum = tf.getSpectrumCount();
            this.m_frame2FirstSpectraIndex.put(tf.getId(), spectrumIndex);
            for (int i = 0; i < nbrSpectrum; ++i) {
                this.m_spectra2FrameIndex.put(spectrumIndex, tf.getId());
                ++spectrumIndex;
            }
            this.m_frameById.put(tf.getId(), (Object)tf);
        }
        this.m_frame2ReadSpectraCount = new Int2IntOpenHashMap(frames.size() * 4 / 3 + 1);
        this.m_precursorByIds = this.m_ttReader.getPrecursorInfoById(this.m_fileHdl);
        long end = System.currentTimeMillis();
        LOG.info("Read meta data for " + frames.size() + " frames and " + this.m_spectra2FrameIndex.size() + " spectrum. Duration : " + (end - start) + " ms");
    }

    private MzDbMetaData createMzDbMetaData() {
        String fileName;
        int pos;
        ParamTree pt = new ParamTree();
        ArrayList<UserParam> ups = new ArrayList<UserParam>();
        ups.add(new UserParam("origin_file_format", "Timstof Brucker", "xsd:string"));
        pt.setUserParams(((Iterator)JavaConverters.asScalaIteratorConverter(ups.iterator()).asScala()).toSeq());
        int currentTime = new Long(System.currentTimeMillis()).intValue();
        MzDbHeader mzdbHeader = new MzDbHeader("0.7", currentTime, pt);
        ArrayList<DataEncoding> des = new ArrayList<DataEncoding>();
        des.add(this.m_profileDataEnconding);
        des.add(this.m_centroidDataEnconding);
        des.add(this.m_fittedDataEnconding);
        Map<String, String> globalProperties = this.m_ttReader.readGlobalProperties(this.m_fileHdl);
        CommonInstrumentParams ciParams = new CommonInstrumentParams(-1, new ParamTree());
        ArrayList<SourceComponent> compos = new ArrayList<SourceComponent>();
        SourceComponent srcCompo = new SourceComponent(1);
        ArrayList<CVParam> params = new ArrayList<CVParam>();
        params.add(new CVParam("MS:1000398", "nanoelectrospray", "", "MS", this.noneOp, this.noneOp, this.noneOp));
        params.add(new CVParam("MS:1000485", "nanospray inlet", "", "MS", this.noneOp, this.noneOp, this.noneOp));
        srcCompo.setCVParams(((Iterator)JavaConverters.asScalaIteratorConverter(params.iterator()).asScala()).toSeq());
        compos.add(srcCompo);
        ComponentList compList = new ComponentList(((Iterator)JavaConverters.asScalaIteratorConverter(compos.iterator()).asScala()).toSeq());
        InstrumentConfiguration iconf = new InstrumentConfiguration(-1, "test", 1, new ParamTree(), compList);
        ArrayList<InstrumentConfiguration> iConfList = new ArrayList<InstrumentConfiguration>();
        iConfList.add(iconf);
        int indexSoft = 1;
        ArrayList<Software> softList = new ArrayList<Software>();
        ParamTree processMethodParamTree = new ParamTree();
        ArrayList<ProcessingMethod> pmList = new ArrayList<ProcessingMethod>();
        if (globalProperties.containsKey("AcquisitionSoftware")) {
            String name = globalProperties.get("AcquisitionSoftware");
            String version = globalProperties.getOrDefault("AcquisitionSoftwareVersion", "Unknown");
            Software soft = new Software(indexSoft++, name, version, new ParamTree());
            softList.add(soft);
        }
        ProcessingMethod pm = new ProcessingMethod(1, 0, "TimsTof_2_mzdb_conversion", Option.apply((Object)processMethodParamTree), indexSoft);
        pmList.add(pm);
        softList.add(new Software(indexSoft++, "ttofConverter", "0.1", new ParamTree()));
        pm = new ProcessingMethod(2, 1, "TimsTof_2_mzdb_conversion", Option.apply((Object)processMethodParamTree), indexSoft);
        pmList.add(pm);
        softList.add(new Software(indexSoft, "mzDB", "0.9.10", new ParamTree()));
        String acqDateStr = globalProperties.get("AcquisitionDateTime");
        Date acqDate = Calendar.getInstance().getTime();
        if (acqDateStr != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            try {
                acqDate = sdf.parse(acqDateStr);
            }
            catch (ParseException e) {
                acqDate = Calendar.getInstance().getTime();
            }
        }
        if ((pos = (fileName = this.m_ttFile.getName()).lastIndexOf(".")) > 0 && pos < fileName.length() - 1) {
            fileName = fileName.substring(0, pos);
        }
        Run r = new Run(-1, fileName, acqDate);
        ArrayList<Run> rList = new ArrayList<Run>();
        rList.add(r);
        String splName = globalProperties.getOrDefault("SampleName", this.m_ttFile.getName() + "_Sample");
        Sample s = new Sample(-1, splName, new ParamTree());
        ArrayList<Sample> sList = new ArrayList<Sample>();
        sList.add(s);
        SourceFile sFile = new SourceFile(1, this.m_ttFile.getName(), this.m_ttFile.getAbsolutePath(), new ParamTree());
        ArrayList<SourceFile> sFileList = new ArrayList<SourceFile>();
        sFileList.add(sFile);
        LOG.info("Created MzDbMetaData.");
        return new MzDbMetaData(mzdbHeader, ((Iterator)JavaConverters.asScalaIteratorConverter(des.iterator()).asScala()).toSeq(), ciParams, ((Iterator)JavaConverters.asScalaIteratorConverter(iConfList.iterator()).asScala()).toSeq(), ((Iterator)JavaConverters.asScalaIteratorConverter(pmList.iterator()).asScala()).toSeq(), ((Iterator)JavaConverters.asScalaIteratorConverter(rList.iterator()).asScala()).toSeq(), ((Iterator)JavaConverters.asScalaIteratorConverter(sList.iterator()).asScala()).toSeq(), ((Iterator)JavaConverters.asScalaIteratorConverter(softList.iterator()).asScala()).toSeq(), ((Iterator)JavaConverters.asScalaIteratorConverter(sFileList.iterator()).asScala()).toSeq());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMZdBData() {
        MzDbWriter writer = null;
        try {
            int spId;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH_mm_ss");
            String date = dateFormat.format(Calendar.getInstance().getTime());
            String outFilePath = this.m_ttFile.getAbsolutePath() + "_" + date + ".mzdb";
            File outFile = new File(outFilePath);
            DefaultBBSizes$ bbsize = DefaultBBSizes$.MODULE$;
            SQLiteFactory$ sf = SQLiteFactory$.MODULE$;
            MzDbMetaData mzDbMetaData = this.createMzDbMetaData();
            writer = new MzDbWriter(outFile, mzDbMetaData, bbsize.apply(), false, (ISQLiteFactory)sf);
            writer.open();
            int mzDBSpId = spId = 1;
            int cycle = 0;
            int nbrSp = this.m_spectra2FrameIndex.size();
            long time_readFrame = 0L;
            long time_ms2 = 0L;
            long time_ms1 = 0L;
            long time_write = 0L;
            while (spId <= nbrSp) {
                long step2;
                long start = System.currentTimeMillis();
                int frameId = this.m_spectra2FrameIndex.get(spId);
                int nbrScanForFrame = this.m_frame2ReadSpectraCount.getOrDefault(frameId, 0);
                this.m_frame2ReadSpectraCount.put(frameId, ++nbrScanForFrame);
                AbstractTimsFrame timsFrame = (AbstractTimsFrame)this.m_frameById.get(frameId);
                if (timsFrame == null) {
                    LOG.warn("#### NO FRAME " + frameId + " for spectra " + spId);
                    ++spId;
                    continue;
                }
                if (!timsFrame.spectrumRead()) {
                    List<AbstractTimsFrame> tfs = Collections.singletonList(timsFrame);
                    this.m_ttReader.fillFramesWithSpectrumData(this.m_fileHdl, tfs);
                }
                com.github.mzdb4s.db.model.params.Precursor mzdbPrecursor = null;
                Spectrum ttSpectrum = null;
                Option preMz = this.noneOp;
                Option preCharge = this.noneOp;
                long step1 = System.currentTimeMillis();
                time_readFrame += step1 - start;
                float rtInSec = (float)timsFrame.getTime();
                int mslevel = 0;
                boolean errFound = false;
                switch (timsFrame.getMsmsType()) {
                    case MS: {
                        mslevel = 1;
                        ++cycle;
                        ttSpectrum = timsFrame.getSingleSpectrum(this.m_ms1Method);
                        step2 = System.currentTimeMillis();
                        time_ms1 += step2 - step1;
                        break;
                    }
                    case PASEF: {
                        mslevel = 2;
                        if (((TimsPASEFFrame)timsFrame).getPrecursorIds() != null) {
                            IntArrayList precursorIds = ((TimsPASEFFrame)timsFrame).getPrecursorIds();
                            Collections.sort(precursorIds);
                            int indexInFrameSpectra = spId - this.m_frame2FirstSpectraIndex.get(timsFrame.getId());
                            if (indexInFrameSpectra >= precursorIds.size() || indexInFrameSpectra < 0) {
                                LOG.warn("#### WARNING #### can't found precursor id  for spectra " + spId + " Index in frame : " + indexInFrameSpectra + ". TimsFrame index" + timsFrame.getId());
                                errFound = true;
                                break;
                            }
                            float RT_EPSILON = 0.05f;
                            rtInSec = indexInFrameSpectra == 0 ? rtInSec : rtInSec + (float)indexInFrameSpectra * RT_EPSILON;
                            int precursorId = (Integer)precursorIds.get(indexInFrameSpectra);
                            ttSpectrum = ((TimsPASEFFrame)timsFrame).getPrecursorSpectrum(precursorId);
                            if (ttSpectrum == null) {
                                LOG.warn("#### WARNING #### No precursor spectrum was defined for frame  " + timsFrame.getId() + "; precursorId : " + precursorId + ". Spectrum index " + spId);
                                errFound = true;
                            } else {
                                Precursor timstofPrecursor = (Precursor)this.m_precursorByIds.get(precursorId);
                                mzdbPrecursor = new com.github.mzdb4s.db.model.params.Precursor();
                                mzdbPrecursor.spectrumRef_$eq(ttSpectrum.getTitle());
                                if (timstofPrecursor != null) {
                                    preMz = Some.apply((Object)timstofPrecursor.getMonoIsotopicMz());
                                    preCharge = Some.apply((Object)timstofPrecursor.getCharge());
                                }
                            }
                            step2 = System.currentTimeMillis();
                            time_ms2 += step2 - step1;
                            break;
                        }
                        LOG.warn("#### WARNING ####  UNSUPPORTED Frame type. Only MS1 and PASEF are supported actually. Frame " + timsFrame.getId() + " is getMsmsType " + (Object)((Object)timsFrame.getMsmsType()));
                        errFound = true;
                        break;
                    }
                    default: {
                        LOG.warn("#### WARNING ####  UNSUPPORTED Frame type. Only MS1 and PASEF are supported actually. Frame " + timsFrame.getId() + " is getMsmsType " + (Object)((Object)timsFrame.getMsmsType()));
                        errFound = true;
                    }
                }
                if (errFound) {
                    if (timsFrame.getSpectrumCount() == nbrScanForFrame) {
                        timsFrame.clearSpectraData();
                    }
                    ++spId;
                    continue;
                }
                step2 = System.currentTimeMillis();
                float[] intensities = ttSpectrum.getIntensities();
                int nbPeaks = intensities.length;
                if (nbPeaks > 0) {
                    int maxIndex = 0;
                    float prevIntensity = intensities[0];
                    for (int index = 1; index < nbPeaks; ++index) {
                        float intAtIndex = intensities[index];
                        if (!(intAtIndex > prevIntensity)) continue;
                        maxIndex = index;
                        prevIntensity = intAtIndex;
                    }
                    float spTIC = timsFrame.getSummedIntensity();
                    SpectrumHeader spH = new SpectrumHeader((long)mzDBSpId, mzDBSpId, ttSpectrum.getTitle(), cycle, rtInSec, mslevel, this.noneOp, nbPeaks, false, spTIC, ttSpectrum.getMasses()[maxIndex], intensities[maxIndex], preMz, preCharge, mzDBSpId, (ScanList)null, mzdbPrecursor, this.noneOp);
                    SpectrumData spData = new SpectrumData(ttSpectrum.getMasses(), ttSpectrum.getIntensities());
                    com.github.mzdb4s.msdata.Spectrum mzdb4sSp = new com.github.mzdb4s.msdata.Spectrum(spH, (ISpectrumData)spData);
                    SpectrumXmlMetaData spectrumMetaData = new SpectrumXmlMetaData((long)mzDBSpId, "", "", Option.empty(), Option.empty());
                    DataEncoding spectrumDE = this.m_centroidDataEnconding;
                    if (timsFrame.getMsmsType().equals((Object)AbstractTimsFrame.MsMsType.MS)) {
                        switch (this.m_ms1Method) {
                            case FULL: 
                            case MERGED: {
                                spectrumDE = this.m_profileDataEnconding;
                            }
                        }
                    }
                    writer.insertSpectrum(mzdb4sSp, spectrumMetaData, spectrumDE);
                    long step4 = System.currentTimeMillis();
                    time_write += step4 - step2;
                } else {
                    LOG.info("mzdb scan id {} has no peaks ! It will not be written in the mzdb outputfile", (Object)mzDBSpId);
                }
                if (timsFrame.getSpectrumCount() == nbrScanForFrame) {
                    timsFrame.clearSpectraData();
                }
                ++mzDBSpId;
                if (++spId % 1000 != 0 && spId != nbrSp) continue;
                LOG.info("Already written {} ({} in mzdb) spectra over {} ", new Object[]{spId, mzDBSpId, nbrSp});
                LOG.debug("Time used to read Frame: " + time_readFrame);
                LOG.debug("Time used to create MS2: " + time_ms2);
                LOG.debug("Time used to create MS1: " + time_ms1);
                LOG.debug("Time used to write data: " + time_write);
                time_readFrame = 0L;
                time_ms2 = 0L;
                time_ms1 = 0L;
                time_write = 0L;
            }
        }
        catch (Exception e) {
            LOG.error("Exception in Spectrum iterator ", (Throwable)e);
            e.printStackTrace();
        }
        catch (Throwable t) {
            LOG.error("Throwable in Spectrum iterator ", t);
            t.printStackTrace();
        }
        finally {
            LOG.debug("Finally  " + writer.loggerName() + " close ");
            writer.close();
        }
    }

    private void testFrameAndQuit(int spId) {
        int frameId = this.m_spectra2FrameIndex.get(spId);
        int nbrScanForFrame = this.m_frame2ReadSpectraCount.getOrDefault(frameId, 0);
        ++nbrScanForFrame;
        AbstractTimsFrame timsFrame = (AbstractTimsFrame)this.m_frameById.get(frameId);
        if (timsFrame != null) {
            if (!timsFrame.spectrumRead()) {
                List<AbstractTimsFrame> tfs = Collections.singletonList(timsFrame);
                this.m_ttReader.fillFramesWithSpectrumData(this.m_fileHdl, tfs);
            }
        } else {
            LOG.warn("#### NO FRAME " + frameId + " for spectra " + spId);
        }
        Spectrum ttSpectrum = timsFrame.getSingleSpectrum(this.m_ms1Method);
        LOG.info("spectrum {}  contains {} peaks", (Object)spId, (Object)ttSpectrum.getMasses().length);
        System.exit(0);
    }

    private void fillmzDBPrecursor(com.github.mzdb4s.db.model.params.Precursor mzdbPrecursor, Precursor timstofPrecursor, String collEnergy) {
        long start = System.currentTimeMillis();
        IsolationWindowParamTree isolationParams = new IsolationWindowParamTree();
        ArrayList<CVParam> isolationParamsList = new ArrayList<CVParam>();
        isolationParamsList.add(new CVParam(PsiMsCV.ISOLATION_WINDOW_TARGET_MZ().getAccession(), "isolation window target m/z", String.valueOf(timstofPrecursor.getMonoIsotopicMz()), "MS", (Option)Some.apply((Object)"MS"), (Option)Some.apply((Object)"MS:1000040"), (Option)Some.apply((Object)"m/z")));
        isolationParams.setCVParams(((Iterator)JavaConverters.asScalaIteratorConverter(isolationParamsList.iterator()).asScala()).toSeq());
        mzdbPrecursor.isolationWindow_$eq(isolationParams);
        Activation activation = new Activation();
        ArrayList<CVParam> params = new ArrayList<CVParam>();
        params.add(new CVParam("MS:1000133", "collision-induced dissociation", "", "MS", this.noneOp, this.noneOp, this.noneOp));
        params.add(new CVParam("MS:1000045", "collision energy", collEnergy, "MS", (Option)Some.apply((Object)"UO"), (Option)Some.apply((Object)"UO:0000266"), (Option)Some.apply((Object)"electronvolt")));
        activation.setCVParams(((Iterator)JavaConverters.asScalaIteratorConverter(params.iterator()).asScala()).toSeq());
        mzdbPrecursor.activation_$eq(activation);
        SelectedIonList ionList = new SelectedIonList();
        ionList.count_$eq(1);
        SelectedIon ion = new SelectedIon();
        ArrayList<SelectedIon> selectedIons = new ArrayList<SelectedIon>();
        ArrayList<CVParam> ionParams = new ArrayList<CVParam>();
        ionParams.add(new CVParam(PsiMsCV.SELECTED_ION_MZ().getAccession(), "selected ion m/z", String.valueOf(timstofPrecursor.getMonoIsotopicMz()), "MS", (Option)Some.apply((Object)"MS"), (Option)Some.apply((Object)"MS:1000040"), (Option)Some.apply((Object)"m/z")));
        ionParams.add(new CVParam("MS:1000041", "charge state", String.valueOf(timstofPrecursor.getCharge()), "MS", this.noneOp, this.noneOp, this.noneOp));
        ionParams.add(new CVParam("MS:1000042", "peak intensity", String.valueOf(timstofPrecursor.getIntensity()), "MS", (Option)Some.apply((Object)"MS"), (Option)Some.apply((Object)"MS:1000131"), (Option)Some.apply((Object)"number of counts")));
        ion.setCVParams(((Iterator)JavaConverters.asScalaIteratorConverter(ionParams.iterator()).asScala()).toSeq());
        selectedIons.add(ion);
        ionList.selectedIons_$eq(((Iterator)JavaConverters.asScalaIteratorConverter(selectedIons.iterator()).asScala()).toSeq());
        mzdbPrecursor.selectedIonList_$eq(ionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        Timstof2Mzdb inst = null;
        ConverterArguments convertArgs = new ConverterArguments();
        JCommander cmd = JCommander.newBuilder().addObject((Object)convertArgs).build();
        try {
            cmd.parse(args);
            String fileToConvert = filepath;
            SpectrumGeneratingMethod ms1Method = SpectrumGeneratingMethod.SMOOTH;
            if (convertArgs.filename != null) {
                LOG.info("File name set to " + convertArgs.filename);
                fileToConvert = convertArgs.filename;
            } else {
                LOG.info("NO File name set, use " + filepath);
            }
            if (convertArgs.ms1 != null) {
                LOG.info("Ms1 set to " + (Object)((Object)convertArgs.ms1));
                ms1Method = convertArgs.ms1;
            } else {
                LOG.info("NO ms1 set, use SMOOTH");
            }
            File ttDir = new File(fileToConvert);
            if (!ttDir.exists()) {
                LOG.error("File " + fileToConvert + " does not exist !! ");
                System.exit(1);
            }
            inst = new Timstof2Mzdb(ttDir, ms1Method);
            inst.createMZdBData();
            if (inst == null) return;
        }
        catch (ParameterException pe) {
            LOG.info("Error parsing arguments: " + pe.getMessage());
            cmd.usage();
            if (inst == null) return;
            LOG.info("Close file");
            inst.closeFile();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (inst == null) return;
            {
                catch (Throwable throwable) {
                    if (inst == null) throw throwable;
                    LOG.info("Close file");
                    super.closeFile();
                    throw throwable;
                }
            }
            LOG.info("Close file");
            inst.closeFile();
            return;
        }
        LOG.info("Close file");
        inst.closeFile();
        return;
    }
}

