/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dpm.serverfilesystem.ServerFile;
import fr.proline.studio.dpm.serverfilesystem.ServerFileSystemView;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.msfiles.WorkingSet;
import fr.proline.studio.msfiles.WorkingSetEntry;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.openide.util.NbPreferences;

public class AddlWorkingSetEntryDialog
extends DefaultDialog {
    private static AddlWorkingSetEntryDialog m_singleton = null;
    private static WorkingSet m_workingSet;
    private JButton m_addLocalFileButton;
    private JButton m_addRemoteFileButton;
    private JButton m_removeFileButton;
    private JScrollPane m_fileListScrollPane;
    private static JList m_fileList;
    private String m_lastLocalParentDirectory;
    private String m_lastLabelUsed;
    private Preferences m_preferences;

    public static AddlWorkingSetEntryDialog getDialog(Window parent, WorkingSet workingSet) {
        m_workingSet = workingSet;
        if (m_singleton == null) {
            m_singleton = new AddlWorkingSetEntryDialog(parent);
        }
        m_singleton.updateRemoteButton();
        return m_singleton;
    }

    private AddlWorkingSetEntryDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Add an entry");
        this.setSize(new Dimension(480, 320));
        this.m_preferences = NbPreferences.root();
        this.setInternalComponent(this.createFileSelectionPanel());
    }

    private JPanel createFileSelectionPanel() {
        JPanel fileSelectionPanel = new JPanel(new GridBagLayout());
        fileSelectionPanel.setBorder(BorderFactory.createTitledBorder(" Files Selection "));
        m_fileList = new JList(new DefaultListModel());
        this.m_fileListScrollPane = new JScrollPane(m_fileList){
            private Dimension preferredSize;
            {
                this.preferredSize = new Dimension(360, 200);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        this.m_addLocalFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
        this.m_addLocalFileButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_addRemoteFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SERVER_ON));
        this.m_addRemoteFileButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_removeFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        this.m_removeFileButton.setMargin(new Insets(2, 2, 2, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        fileSelectionPanel.add((Component)this.m_fileListScrollPane, c);
        ++c.gridx;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        fileSelectionPanel.add((Component)this.m_addLocalFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add((Component)this.m_addRemoteFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add((Component)this.m_removeFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add(Box.createVerticalStrut(30), c);
        m_fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean sometingSelected = m_fileList.getSelectedIndex() != -1;
                AddlWorkingSetEntryDialog.this.m_removeFileButton.setEnabled(sometingSelected);
            }
        });
        this.m_addLocalFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String localInitDirectory = AddlWorkingSetEntryDialog.this.m_preferences.get("New_Entry_Dialog.LAST_LOCAL_MZDB_PATH", System.getProperty("user.home"));
                File f = new File(localInitDirectory);
                if (!f.exists() || !f.isDirectory()) {
                    localInitDirectory = System.getProperty("user.home");
                }
                JFileChooser fchooser = new JFileChooser(localInitDirectory);
                fchooser.setMultiSelectionEnabled(true);
                fchooser.addChoosableFileFilter(new FileNameExtensionFilter(".mzdb", "mzDB"));
                fchooser.setAcceptAllFileFilterUsed(false);
                int result = fchooser.showOpenDialog((Component)((Object)m_singleton));
                if (result == 0) {
                    File[] files = fchooser.getSelectedFiles();
                    int nbFiles = files.length;
                    for (int i = 0; i < nbFiles; ++i) {
                        ((DefaultListModel)m_fileList.getModel()).addElement(files[i]);
                    }
                    if (files.length > 0) {
                        AddlWorkingSetEntryDialog.this.m_lastLocalParentDirectory = files[0].getParentFile().getAbsolutePath();
                    }
                }
            }
        });
        this.m_addRemoteFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                File[] roots = ServerFileSystemView.getServerFileSystemView().getRoots();
                String remoteInitDirectory = AddlWorkingSetEntryDialog.this.m_preferences.get("New_Entry_Dialog.LAST_REMOTE_MZDB_PATH_LABEL", roots[0].getAbsolutePath());
                for (index = 0; index < roots.length - 1 && !remoteInitDirectory.startsWith(roots[index].getAbsolutePath()); ++index) {
                }
                JFileChooser fchooser = new JFileChooser(roots[index], (FileSystemView)ServerFileSystemView.getServerFileSystemView());
                fchooser.setMultiSelectionEnabled(true);
                fchooser.addChoosableFileFilter(new FileNameExtensionFilter(".mzdb", "mzDB"));
                fchooser.setAcceptAllFileFilterUsed(false);
                int result = fchooser.showOpenDialog((Component)((Object)m_singleton));
                if (result == 0) {
                    File[] files = fchooser.getSelectedFiles();
                    int nbFiles = files.length;
                    for (int i = 0; i < nbFiles; ++i) {
                        ((DefaultListModel)m_fileList.getModel()).addElement(new ServerFile(files[i].getPath(), files[i].getPath(), true, 0L, 0L));
                    }
                    if (files.length > 0) {
                        AddlWorkingSetEntryDialog.this.m_lastLabelUsed = files[0].getParentFile().getAbsolutePath();
                    }
                }
            }
        });
        this.m_removeFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedValues = m_fileList.getSelectedValuesList();
                Iterator it = selectedValues.iterator();
                while (it.hasNext()) {
                    ((DefaultListModel)m_fileList.getModel()).removeElement(it.next());
                }
                AddlWorkingSetEntryDialog.this.m_removeFileButton.setEnabled(false);
            }
        });
        return fileSelectionPanel;
    }

    protected boolean okCalled() {
        if (!this.validateParameters()) {
            return false;
        }
        if (this.m_lastLocalParentDirectory != null) {
            this.m_preferences.put("New_Entry_Dialog.LAST_LOCAL_MZDB_PATH", this.m_lastLocalParentDirectory);
        }
        if (this.m_lastLabelUsed != null) {
            this.m_preferences.put("New_Entry_Dialog.LAST_REMOTE_MZDB_PATH_LABEL", this.m_lastLabelUsed);
        }
        for (int i = 0; i < m_fileList.getModel().getSize(); ++i) {
            File f = (File)m_fileList.getModel().getElementAt(i);
            WorkingSetEntry.Location location = f instanceof ServerFile ? WorkingSetEntry.Location.REMOTE : WorkingSetEntry.Location.LOCAL;
            m_workingSet.addEntry(f.getAbsolutePath(), location);
        }
        DefaultListModel listModel = (DefaultListModel)m_fileList.getModel();
        listModel.removeAllElements();
        return true;
    }

    private void updateRemoteButton() {
        this.m_addRemoteFileButton.setEnabled(DatabaseDataManager.getDatabaseDataManager().getLoggedUser() != null);
    }

    private boolean validateParameters() {
        return true;
    }
}

