/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.profi.mzdb.io.writer.mgf.DefaultPrecursorComputer;
import fr.profi.mzdb.io.writer.mgf.IPrecursorComputation;
import fr.profi.mzdb.io.writer.mgf.IsolationWindowPrecursorExtractor;
import fr.profi.mzdb.io.writer.mgf.PrecursorMzComputationEnum;
import fr.proline.mzscope.ui.MgfExportParameters;
import fr.proline.mzscope.ui.ScanHeaderType;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.msfiles.MgfExportBatch;
import fr.proline.studio.msfiles.MgfExportSettings;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.FileParameter;
import fr.proline.studio.parameter.FloatParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.rsmexplorer.gui.dialog.FileDialogInterface;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.util.NbPreferences;

public class ExportMgfDialog
extends DefaultDialog
implements FileDialogInterface {
    private static ExportMgfDialog m_singleton = null;
    public static final String MZ_TOLERANCE_KEY = "MZ_TOLERANCE_KEY";
    public static final String MZ_TOLERANCE_NAME = "M/z tolerance (ppm)";
    public static final String INTENSITY_CUTOFF_KEY = "INTENSITY_CUTOFF_KEY";
    public static final String INTENSITY_CUTOFF_NAME = "Intensity cutoff";
    public static final String MZ_PRECURSOR_METHOD_KEY = "MZ_PRECURSOR_METHOD_KEY";
    public static final String MZ_PRECURSOR_METHOD_NAME = "Precursor m/z computation method";
    public static final String EXPORT_TITLE_KEY = "EXPORT_TITLE_KEY";
    public static final String EXPORT_TITLE_NAME = "Export proline title";
    public static final String EXPORT_OUTPUT_KEY = "EXPORT_OUTPUT_KEY";
    public static final String EXPORT_OUTPUT_NAME = "Select directory";
    public static final String EXPORT_IN_DIRECTORY_KEY = "EXPORT_IN_DIRECTORY_KEY";
    public static final String EXPORT_IN_DIRECTORY_NAME = "Export in specified directory";
    public static final String EXPORT_IN_PARENT_DIR_KEY = "EXPORT_IN_PARENT_DIR_KEY";
    public static final String EXPORT_IN_PARENT_DIR_NAME = "Export in .mzdb file's directory";
    private FloatParameter m_mzToleranceParam;
    private FloatParameter m_intensityCutoffParam;
    private BooleanParameter m_prolineTitleParam;
    private BooleanParameter m_exportInDirectoryParam;
    private BooleanParameter m_exportInParentParam;
    private FileParameter m_outputParam;
    private JComboBox m_precursorMethod;
    private JCheckBox m_exportProlineTitle;
    private JRadioButton m_exportInDirectoryButton;
    private JRadioButton m_exportInParentDirParam;
    private final String[] m_scanHeaderList;
    private final Map<Integer, ScanHeaderType> m_mapScanHeader;
    private final String[] m_precursorList;
    private static final String ISOLATION_WINDOW_PRECURSOR = "Proline refined precursor mz";
    private JButton m_addFileButton;
    private JButton m_removeFileButton;
    private JScrollPane m_fileListScrollPane;
    private static JList m_fileList;
    private String m_lastParentDirectory;
    private ParameterList m_exportParameterList;
    private ParameterList m_outputParameterList;
    public static final String MGF_EXPORT_NAME = "Mgf Export Parameters";
    public static final String MGF_EXPORT_PARAM_KEY = "MGF_EXPORT_KEY";
    public static final String MGF_OUTPUT_NAME = "Mgf Output Parameters";
    public static final String MGF_OUTPUT_KEY = "MGF_OUTPUT_KEY";
    private final Preferences m_preferences;

    public static ExportMgfDialog getDialog(Window parent, String title) {
        if (m_singleton == null) {
            m_singleton = new ExportMgfDialog(parent, title);
        }
        return m_singleton;
    }

    private ExportMgfDialog(Window parent, String title) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(title);
        this.setDocumentationSuffix(null);
        this.m_preferences = NbPreferences.root();
        EnumSet<PrecursorMzComputationEnum> precursorSet = EnumSet.allOf(PrecursorMzComputationEnum.class);
        this.m_precursorList = new String[precursorSet.size() + 1];
        int i = 0;
        for (PrecursorMzComputationEnum p : precursorSet) {
            this.m_precursorList[i] = p.getUserParamName();
            ++i;
        }
        this.m_precursorList[i] = ISOLATION_WINDOW_PRECURSOR;
        EnumSet<ScanHeaderType> scanHeaderSet = EnumSet.allOf(ScanHeaderType.class);
        this.m_scanHeaderList = new String[scanHeaderSet.size()];
        this.m_mapScanHeader = new HashMap<Integer, ScanHeaderType>();
        i = 0;
        for (ScanHeaderType s : scanHeaderSet) {
            this.m_scanHeaderList[i] = s.getName();
            this.m_mapScanHeader.put(i, s);
            ++i;
        }
        this.setInternalComponent(this.createInternalPanel());
        this.setButtonName(0, "Export");
    }

    @Override
    public void setFiles(ArrayList<File> files) {
        ((DefaultListModel)m_fileList.getModel()).clear();
        if (files.size() > 0) {
            for (File f : files) {
                ((DefaultListModel)m_fileList.getModel()).addElement(f);
            }
            this.m_lastParentDirectory = files.get(0).getParentFile().getAbsolutePath();
        }
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new BorderLayout());
        internalPanel.add((Component)this.createOutputParameterPanel(), "North");
        internalPanel.add((Component)this.createFileSelectionPanel(), "Center");
        internalPanel.add((Component)this.createParametersPanel(), "South");
        return internalPanel;
    }

    private JPanel createOutputParameterPanel() {
        this.m_outputParameterList = new ParameterList(MGF_OUTPUT_KEY);
        ButtonGroup group = new ButtonGroup();
        this.m_exportInParentDirParam = new JRadioButton(EXPORT_IN_PARENT_DIR_NAME);
        this.m_exportInParentDirParam.setHorizontalTextPosition(4);
        this.m_exportInParentParam = new BooleanParameter(EXPORT_IN_PARENT_DIR_KEY, "", (JComponent)this.m_exportInParentDirParam, Boolean.FALSE);
        this.m_outputParameterList.add((Object)this.m_exportInParentParam);
        group.add(this.m_exportInParentDirParam);
        this.m_exportInDirectoryButton = new JRadioButton(EXPORT_IN_DIRECTORY_NAME);
        this.m_exportInDirectoryButton.setHorizontalTextPosition(4);
        this.m_exportInDirectoryButton.setSelected(true);
        this.m_exportInDirectoryParam = new BooleanParameter(EXPORT_IN_DIRECTORY_KEY, EXPORT_IN_DIRECTORY_NAME, (JComponent)this.m_exportInDirectoryButton, Boolean.TRUE);
        this.m_outputParameterList.add((Object)this.m_exportInDirectoryParam);
        group.add(this.m_exportInDirectoryButton);
        String s = this.m_preferences.get("MGF_OUTPUT_KEY.EXPORT_OUTPUT_KEY", System.getProperty("user.home"));
        final File defaultDirectory = new File(s);
        if (!defaultDirectory.exists() || !defaultDirectory.isDirectory()) {
            s = System.getProperty("user.home");
        }
        this.m_outputParam = new FileParameter(null, EXPORT_OUTPUT_KEY, EXPORT_OUTPUT_NAME, JTextField.class, this.m_preferences.get("MGF_OUTPUT_KEY.EXPORT_OUTPUT_KEY", defaultDirectory.getAbsolutePath()), null, null);
        this.m_outputParam.forceShowLabel(AbstractParameter.LabelVisibility.NO_VISIBLE);
        this.m_outputParam.setAllFiles(false);
        this.m_outputParam.setSelectionMode(1);
        this.m_outputParam.setDefaultDirectory(defaultDirectory);
        this.m_outputParameterList.add((Object)this.m_outputParam);
        AbstractLinkedParameters linkedParameters = new AbstractLinkedParameters(this.m_outputParameterList){

            public void valueChanged(String value, Object associatedValue) {
                String stringValue = ExportMgfDialog.this.m_outputParam.getStringValue();
                if (stringValue.equalsIgnoreCase("")) {
                    stringValue = defaultDirectory.getAbsolutePath();
                }
                this.showParameter((AbstractParameter)ExportMgfDialog.this.m_outputParam, ExportMgfDialog.this.m_exportInDirectoryButton.isSelected(), stringValue);
                this.updateParameterListPanel();
            }
        };
        this.m_exportInParentParam.addLinkedParameters(linkedParameters);
        this.m_exportInDirectoryParam.addLinkedParameters(linkedParameters);
        linkedParameters.valueChanged(this.m_exportInParentParam.getStringValue(), this.m_exportInParentParam.getObjectValue());
        this.m_outputParameterList.getPanel().setBorder((Border)BorderFactory.createTitledBorder("Output directory"));
        return this.m_outputParameterList.getPanel();
    }

    private JPanel createParametersPanel() {
        this.m_exportParameterList = new ParameterList(MGF_EXPORT_PARAM_KEY);
        this.m_mzToleranceParam = new FloatParameter(MZ_TOLERANCE_KEY, MZ_TOLERANCE_NAME, JTextField.class, Float.valueOf(10.0f), Float.valueOf(1.0f), Float.valueOf(100.0f));
        this.m_exportParameterList.add((Object)this.m_mzToleranceParam);
        this.m_precursorMethod = new JComboBox<String>(this.m_precursorList);
        ObjectParameter precursorMethodParameter = new ObjectParameter(MZ_PRECURSOR_METHOD_KEY, MZ_PRECURSOR_METHOD_NAME, this.m_precursorMethod, (Object[])this.m_precursorList, (Object[])this.m_precursorList, 2, null);
        this.m_exportParameterList.add((Object)precursorMethodParameter);
        this.m_intensityCutoffParam = new FloatParameter(INTENSITY_CUTOFF_KEY, INTENSITY_CUTOFF_NAME, JTextField.class, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1000000.0f));
        this.m_exportParameterList.add((Object)this.m_intensityCutoffParam);
        this.m_exportProlineTitle = new JCheckBox("Export Proline Title");
        this.m_prolineTitleParam = new BooleanParameter(EXPORT_TITLE_KEY, EXPORT_TITLE_NAME, (JComponent)this.m_exportProlineTitle, Boolean.FALSE);
        this.m_exportParameterList.add((Object)this.m_prolineTitleParam);
        this.m_exportParameterList.loadParameters(this.m_preferences);
        this.m_exportParameterList.getPanel().setBorder((Border)BorderFactory.createTitledBorder("Export Parameters"));
        return this.m_exportParameterList.getPanel();
    }

    private JPanel createFileSelectionPanel() {
        JPanel fileSelectionPanel = new JPanel(new GridBagLayout());
        fileSelectionPanel.setBorder(BorderFactory.createTitledBorder(" Files Selection "));
        m_fileList = new JList(new DefaultListModel());
        this.m_fileListScrollPane = new JScrollPane(m_fileList){
            private Dimension preferredSize;
            {
                this.preferredSize = new Dimension(360, 200);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        this.m_addFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
        this.m_addFileButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_removeFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        this.m_removeFileButton.setMargin(new Insets(2, 2, 2, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        fileSelectionPanel.add((Component)this.m_fileListScrollPane, c);
        ++c.gridx;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        fileSelectionPanel.add((Component)this.m_addFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add((Component)this.m_removeFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add(Box.createVerticalStrut(30), c);
        m_fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean sometingSelected = m_fileList.getSelectedIndex() != -1;
                ExportMgfDialog.this.m_removeFileButton.setEnabled(sometingSelected);
            }
        });
        this.m_addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String initializationDirectory = ExportMgfDialog.this.m_preferences.get("MGF_EXPORT_KEY.LAST_MZDB_PATH", System.getProperty("user.home"));
                File f = new File(initializationDirectory);
                if (!f.exists() || !f.isDirectory()) {
                    initializationDirectory = System.getProperty("user.home");
                }
                JFileChooser fchooser = new JFileChooser(initializationDirectory);
                fchooser.setMultiSelectionEnabled(true);
                fchooser.addChoosableFileFilter(new FileNameExtensionFilter(".mzdb", "mzDB"));
                fchooser.setAcceptAllFileFilterUsed(false);
                int result = fchooser.showOpenDialog((Component)((Object)m_singleton));
                if (result == 0) {
                    File[] files = fchooser.getSelectedFiles();
                    int nbFiles = files.length;
                    for (int i = 0; i < nbFiles; ++i) {
                        ((DefaultListModel)m_fileList.getModel()).addElement(files[i]);
                    }
                    if (files.length > 0) {
                        ExportMgfDialog.this.m_lastParentDirectory = files[0].getParentFile().getAbsolutePath();
                    }
                }
            }
        });
        this.m_removeFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedValues = m_fileList.getSelectedValuesList();
                Iterator it = selectedValues.iterator();
                while (it.hasNext()) {
                    ((DefaultListModel)m_fileList.getModel()).removeElement(it.next());
                }
                ExportMgfDialog.this.m_removeFileButton.setEnabled(false);
            }
        });
        return fileSelectionPanel;
    }

    protected boolean okCalled() {
        if (!this.validateParameters()) {
            return false;
        }
        this.m_outputParameterList.saveParameters(this.m_preferences);
        this.m_exportParameterList.saveParameters(this.m_preferences);
        this.m_preferences.put("mzDB_Settings.LAST_MZDB_PATH", this.m_lastParentDirectory);
        HashMap<File, MgfExportSettings> mzdbFiles = new HashMap<File, MgfExportSettings>();
        for (int i = 0; i < m_fileList.getModel().getSize(); ++i) {
            File f = (File)m_fileList.getModel().getElementAt(i);
            MgfExportParameters exportParameters = new MgfExportParameters(this.buildPrecursorComputer(), Float.parseFloat(this.m_mzToleranceParam.getStringValue()), Float.parseFloat(this.m_intensityCutoffParam.getStringValue()), this.m_exportProlineTitle.isSelected());
            String exportPath = (Boolean)this.m_exportInParentParam.getObjectValue() != false ? f.getParentFile().getAbsolutePath() : this.m_outputParam.getStringValue();
            MgfExportSettings exportSettings = new MgfExportSettings(exportPath, exportParameters);
            mzdbFiles.put((File)m_fileList.getModel().getElementAt(i), exportSettings);
        }
        MgfExportBatch exportBatch = new MgfExportBatch(mzdbFiles);
        Thread thread = new Thread(exportBatch);
        thread.start();
        DefaultListModel listModel = (DefaultListModel)m_fileList.getModel();
        listModel.removeAllElements();
        return true;
    }

    private IPrecursorComputation buildPrecursorComputer() {
        IsolationWindowPrecursorExtractor precComp = null;
        String item = (String)this.m_precursorMethod.getSelectedItem();
        if (item.equals(ISOLATION_WINDOW_PRECURSOR)) {
            precComp = new IsolationWindowPrecursorExtractor(Float.parseFloat(this.m_mzToleranceParam.getStringValue()));
        }
        EnumSet<PrecursorMzComputationEnum> precursorSet = EnumSet.allOf(PrecursorMzComputationEnum.class);
        for (PrecursorMzComputationEnum p : precursorSet) {
            if (!item.equals(p.getUserParamName())) continue;
            precComp = new DefaultPrecursorComputer(p, Float.parseFloat(this.m_intensityCutoffParam.getStringValue()));
            break;
        }
        return precComp;
    }

    private boolean validateParameters() {
        if (m_fileList.getModel().getSize() == 0) {
            this.setStatus(true, "No files are selected.");
            this.highlight(m_fileList);
            return false;
        }
        ParameterError error = this.m_exportParameterList.checkParameters();
        if (error != null) {
            this.setStatus(true, error.getErrorMessage());
            this.highlight(error.getParameterComponent());
            return false;
        }
        return true;
    }
}

