/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.msfiles.MgfExportSettings;
import fr.proline.studio.msfiles.MgfExportTask;
import fr.proline.studio.msfiles.MzdbEncodingVerificationTask;
import fr.proline.studio.msfiles.MzdbIntegrityVerificationTask;
import fr.proline.studio.rsmexplorer.MzdbFilesTopComponent;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MgfExportBatch
implements Runnable {
    private final HashMap<File, MgfExportSettings> m_exports;
    private HashSet<String> m_parentDirectories;

    public MgfExportBatch(HashMap<File, MgfExportSettings> exports) {
        this.m_exports = exports;
    }

    @Override
    public void run() {
        this.m_parentDirectories = new HashSet();
        for (Map.Entry<File, MgfExportSettings> pair : this.m_exports.entrySet()) {
            File f = pair.getKey();
            MgfExportSettings settings = pair.getValue();
            File outputDirectory = new File(settings.getDestinationDirectory());
            while (outputDirectory.getParentFile() != null) {
                this.m_parentDirectories.add(outputDirectory.getAbsolutePath());
                outputDirectory = outputDirectory.getParentFile();
            }
            MzdbFilesTopComponent.getExplorer().getLocalFileSystemView().expandMultipleTreePath(this.m_parentDirectories);
            MzdbFilesTopComponent.getExplorer().getLocalFileSystemView().updateTree();
        }
        for (Map.Entry<File, MgfExportSettings> pair : this.m_exports.entrySet()) {
            File f = pair.getKey();
            MgfExportSettings settings = pair.getValue();
            this.export(f, settings);
        }
    }

    private void export(final File f, final MgfExportSettings settings) {
        if (f.getAbsolutePath().toLowerCase().endsWith(".mzdb")) {
            AbstractDatabaseCallback encodingCallback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (success) {
                        AbstractDatabaseCallback integrityCallback = new AbstractDatabaseCallback(){

                            public boolean mustBeCalledInAWT() {
                                return false;
                            }

                            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                                if (success) {
                                    AbstractDatabaseCallback exportMgfCallback = new AbstractDatabaseCallback(){

                                        public boolean mustBeCalledInAWT() {
                                            return false;
                                        }

                                        public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                                            if (success) {
                                                MzdbFilesTopComponent.getExplorer().getLocalFileSystemView().updateTree();
                                            }
                                        }
                                    };
                                    MgfExportTask exportMgfTask = new MgfExportTask(exportMgfCallback, f, settings);
                                    AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)exportMgfTask);
                                }
                            }
                        };
                        MzdbIntegrityVerificationTask verificationTask = new MzdbIntegrityVerificationTask(integrityCallback, f);
                        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)verificationTask);
                    }
                }
            };
            MzdbEncodingVerificationTask encodingVerificationTask = new MzdbEncodingVerificationTask(encodingCallback, f);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)encodingVerificationTask);
        }
    }
}

