/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.DownloadFileTask;
import fr.proline.studio.msfiles.MsListener;
import fr.proline.studio.msfiles.MsListenerDownloadParameter;
import fr.proline.studio.msfiles.MsListenerEntryUpdateParameter;
import fr.proline.studio.msfiles.WorkingSetEntry;
import fr.proline.studio.rsmexplorer.MzdbFilesTopComponent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.tree.TreePath;

public class MzdbDownloadBatch
implements Runnable {
    private TreePath m_pathToExpand;
    private final String m_localURL;
    private ArrayList<File> m_files;
    private ArrayList<WorkingSetEntry> m_entries;
    private final String m_root;
    private MsListener m_listener;
    private ArrayList<MsListenerDownloadParameter> m_downloadList;
    private File m_localFile;

    public MzdbDownloadBatch(ArrayList<File> files, TreePath pathToExpand, String root) {
        this.m_files = files;
        this.m_pathToExpand = pathToExpand;
        this.m_root = root;
        this.m_downloadList = new ArrayList();
        StringBuilder temp = new StringBuilder();
        Object[] elements = pathToExpand.getPath();
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            temp.append(elements[i]).append("\\");
        }
        this.m_localURL = temp.toString();
    }

    public MzdbDownloadBatch(String localURL, String root, ArrayList<WorkingSetEntry> entries) {
        this.m_entries = entries;
        this.m_root = root;
        this.m_localURL = localURL;
        this.m_downloadList = new ArrayList();
    }

    public void addMsListener(MsListener listener) {
        this.m_listener = listener;
    }

    private void downloadFile(final File remoteFile) {
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                if (success) {
                    if (MzdbDownloadBatch.this.m_pathToExpand != null) {
                        MzdbFilesTopComponent.getExplorer().getLocalFileSystemView().updateTree();
                    }
                    MzdbDownloadBatch.this.m_downloadList.add(new MsListenerDownloadParameter(MzdbDownloadBatch.this.m_localFile, remoteFile, true));
                } else {
                    MzdbDownloadBatch.this.m_downloadList.add(new MsListenerDownloadParameter(MzdbDownloadBatch.this.m_localFile, remoteFile, false));
                }
                if (MzdbDownloadBatch.this.m_listener != null && MzdbDownloadBatch.this.m_downloadList.size() == MzdbDownloadBatch.this.m_files.size()) {
                    MzdbDownloadBatch.this.m_listener.downloadPerformed(MzdbDownloadBatch.this.m_downloadList);
                }
            }
        };
        String destinationDirectory = this.m_root + this.m_localURL;
        String filename = remoteFile.getName();
        String url = destinationDirectory + File.separatorChar + filename;
        this.m_localFile = new File(url);
        while (this.m_localFile.exists()) {
            int lastIndexOfDot = url.lastIndexOf(".");
            url = lastIndexOfDot != -1 ? url.substring(0, lastIndexOfDot) + " - Copie" + url.substring(lastIndexOfDot, url.length()) : url + " - Copie";
            this.m_localFile = new File(url);
        }
        DownloadFileTask task = new DownloadFileTask(callback, remoteFile.getAbsolutePath(), this.m_localFile);
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
    }

    private void downloadEntry(final WorkingSetEntry entry) {
        if (entry.getFile().getAbsolutePath().toLowerCase().endsWith(".mzdb")) {
            AbstractJMSCallback callback = new AbstractJMSCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success) {
                    if (success) {
                        if (MzdbDownloadBatch.this.m_pathToExpand != null) {
                            MzdbFilesTopComponent.getExplorer().getLocalFileSystemView().updateTree();
                        }
                        MzdbDownloadBatch.this.m_downloadList.add(new MsListenerDownloadParameter(MzdbDownloadBatch.this.m_localFile, entry.getFile(), true));
                    } else {
                        MzdbDownloadBatch.this.m_downloadList.add(new MsListenerDownloadParameter(MzdbDownloadBatch.this.m_localFile, entry.getFile(), false));
                    }
                    if (MzdbDownloadBatch.this.m_listener != null) {
                        ArrayList<MsListenerEntryUpdateParameter> stateList = new ArrayList<MsListenerEntryUpdateParameter>();
                        stateList.add(new MsListenerEntryUpdateParameter(entry.getFile(), MsListenerEntryUpdateParameter.State.DOWNLOAD_COMPLETE));
                        MzdbDownloadBatch.this.m_listener.entryStateUpdated(stateList);
                        if (MzdbDownloadBatch.this.m_downloadList.size() == MzdbDownloadBatch.this.m_entries.size()) {
                            MzdbDownloadBatch.this.m_listener.downloadPerformed(MzdbDownloadBatch.this.m_downloadList);
                        }
                    }
                }
            };
            String destinationDirectory = this.m_root + this.m_localURL;
            String filename = entry.getFilename();
            String url = destinationDirectory + File.separatorChar + filename;
            this.m_localFile = new File(url);
            while (this.m_localFile.exists()) {
                url = url.substring(0, url.lastIndexOf(".")) + " - Copie.mzdb";
                this.m_localFile = new File(url);
            }
            DownloadFileTask task = new DownloadFileTask(callback, entry.getFile().getAbsolutePath(), this.m_localFile);
            if (this.m_listener != null) {
                ArrayList<MsListenerEntryUpdateParameter> list = new ArrayList<MsListenerEntryUpdateParameter>();
                list.add(new MsListenerEntryUpdateParameter(entry.getFile(), MsListenerEntryUpdateParameter.State.START_DOWNLOADING));
                this.m_listener.entryStateUpdated(list);
            }
            AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
        }
    }

    @Override
    public void run() {
        block4: {
            block3: {
                if (this.m_pathToExpand != null) {
                    MzdbFilesTopComponent.getExplorer().getLocalFileSystemView().expandTreePath(this.m_pathToExpand);
                }
                if (this.m_files == null) break block3;
                for (int i = 0; i < this.m_files.size(); ++i) {
                    this.downloadFile(this.m_files.get(i));
                }
                break block4;
            }
            if (this.m_entries == null) break block4;
            for (int i = 0; i < this.m_entries.size(); ++i) {
                this.downloadEntry(this.m_entries.get(i));
            }
        }
    }
}

