/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabasePTMSitesTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMDataset;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.MsQueryInfoRsm;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.PTMPeptidesTablePanel;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataBoxPTMPeptides
extends AbstractDataBox {
    protected ResultSummary m_rsm;
    protected PTMDataset m_ptmDataset;
    protected List<PTMPeptideInstance> m_ptmPepInstances;
    protected List<PTMCluster> m_ptmClusters;
    protected boolean m_isXICResult = true;
    protected boolean m_displayAllPepMatches = false;
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.ptm");
    private Long m_previousPTMTaskId = null;

    public AbstractDataBoxPTMPeptides(AbstractDataBox.DataboxType type, AbstractDataBox.DataboxStyle style) {
        super(type, style);
    }

    protected void registerParameters() {
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(PTMPeptideInstance.class, this.m_displayAllPepMatches ? ParameterSubtypeEnum.LEAF_PTMPeptideInstance : ParameterSubtypeEnum.PARENT_PTMPeptideInstance);
        inParameter.addParameter(PTMPeptideInstance.class);
        inParameter.addParameter(PTMDataset.class);
        if (this.m_isXICResult) {
            inParameter.addParameter(QuantChannelInfo.class);
            inParameter.addParameter(DMasterQuantProteinSet.class);
        }
        inParameter.addParameter(PTMCluster.class, ParameterSubtypeEnum.LIST_DATA);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(PTMPeptideInstance.class);
        outParameter.addParameter(PTMPeptideInstance.class, ParameterSubtypeEnum.PARENT_PTMPeptideInstance);
        outParameter.addParameter(PTMPeptideInstance.class, ParameterSubtypeEnum.LEAF_PTMPeptideInstance);
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(DPeptideInstance.class);
        outParameter.addParameter(DPeptideInstance.class, ParameterSubtypeEnum.LIST_DATA);
        outParameter.addParameter(ResultSummary.class);
        outParameter.addParameter(PTMDataset.class);
        if (this.m_isXICResult) {
            outParameter.addParameter(ExtendedTableModelInterface.class);
        }
        outParameter.addParameter(MsQueryInfoRsm.class);
        this.registerOutParameter(outParameter);
    }

    protected boolean isAllPSMsDisplayed() {
        return this.m_displayAllPepMatches;
    }

    protected boolean isQuantiResult() {
        return this.m_isXICResult;
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        DataBoxPanelInterface panel = this.getDataBoxPanelInterface();
        if (parameterType != null && (!(panel instanceof SplittedPanelContainer.ReactiveTabbedComponent) || panel instanceof SplittedPanelContainer.ReactiveTabbedComponent && ((SplittedPanelContainer.ReactiveTabbedComponent)panel).isShowed())) {
            if (parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
                DPeptideMatch match;
                PTMPeptideInstance selectedParentPepInstance;
                if (parameterType.equals(Integer.class)) {
                    return this.getSelectedIndex();
                }
                if (parameterType.equals(ResultSummary.class) && this.m_rsm != null) {
                    return this.m_rsm;
                }
                if (parameterType.equals(PTMDataset.class)) {
                    return this.m_ptmDataset;
                }
                if (parameterType.equals(DPeptideInstance.class) && (selectedParentPepInstance = this.getSelectedPTMPeptide()) != null) {
                    return selectedParentPepInstance.getPeptideInstance();
                }
                if (parameterType.equals(DPeptideMatch.class) && (selectedParentPepInstance = this.getSelectedPTMPeptide()) != null) {
                    return selectedParentPepInstance.getRepresentativePepMatch(this.m_ptmClusters);
                }
                if (parameterType.equals(ExtendedTableModelInterface.class)) {
                    return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
                }
                if (parameterType.equals(MsQueryInfoRsm.class) && (selectedParentPepInstance = this.getSelectedPTMPeptide()) != null && (match = this.getSelectedPeptideMatch()) != null) {
                    return new MsQueryInfoRsm(match.getMsQuery(), selectedParentPepInstance.getPeptideInstance().getResultSummary());
                }
                if (parameterType.equals(PTMPeptideInstance.class) && (selectedParentPepInstance = this.getSelectedPTMPeptide()) != null) {
                    return selectedParentPepInstance;
                }
            }
            if (parameterSubtype == ParameterSubtypeEnum.LIST_DATA && parameterType.equals(DPeptideInstance.class)) {
                if (this.m_ptmPepInstances == null) {
                    return new ArrayList();
                }
                return this.m_ptmPepInstances.stream().map(ptpPepInst -> ptpPepInst.getPeptideInstance()).collect(Collectors.toList());
            }
            if (parameterType.equals(PTMPeptideInstance.class) && (parameterSubtype.equals((Object)ParameterSubtypeEnum.PARENT_PTMPeptideInstance) && !this.m_displayAllPepMatches || parameterSubtype.equals((Object)ParameterSubtypeEnum.LEAF_PTMPeptideInstance) && this.m_displayAllPepMatches)) {
                if (this.m_ptmPepInstances == null) {
                    return new ArrayList();
                }
                ArrayList<PTMPeptideInstance> ptmPepInstances = new ArrayList<PTMPeptideInstance>(this.m_ptmPepInstances);
                return ptmPepInstances;
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public void dataChanged() {
        boolean valueUnchanged;
        this.linkCache((TransientDataInterface)this.m_rsm);
        PTMDataset newPtmDataset = (PTMDataset)this.m_previousDataBox.getData(PTMDataset.class);
        ParameterSubtypeEnum parameterSubtype = this.m_displayAllPepMatches ? ParameterSubtypeEnum.LEAF_PTMPeptideInstance : ParameterSubtypeEnum.PARENT_PTMPeptideInstance;
        List newPtmPepInstances = (List)this.m_previousDataBox.getData(PTMPeptideInstance.class, parameterSubtype);
        boolean bl = valueUnchanged = Objects.equals(newPtmDataset, this.m_ptmDataset) && Objects.equals(newPtmPepInstances, this.m_ptmPepInstances);
        if (valueUnchanged) {
            PTMPeptideInstance selectedPep = (PTMPeptideInstance)this.m_previousDataBox.getData(PTMPeptideInstance.class);
            this.setSelectedPTMPeptide(selectedPep);
            return;
        }
        this.m_ptmDataset = newPtmDataset;
        this.m_ptmPepInstances = newPtmPepInstances;
        this.m_ptmClusters = (List)this.m_previousDataBox.getData(PTMCluster.class, ParameterSubtypeEnum.LIST_DATA);
        this.m_rsm = this.m_ptmDataset.getDataset().getResultSummary();
        this.updateData();
    }

    protected List<PTMSite> getNotLoadedPTMSite() {
        ArrayList<PTMSite> notLoadedPtmSite = new ArrayList<PTMSite>();
        for (PTMPeptideInstance ptmPepInst : this.m_ptmPepInstances) {
            ptmPepInst.getPTMSites().stream().forEach(ptmSite -> {
                if (!ptmSite.isLoaded()) {
                    notLoadedPtmSite.add((PTMSite)ptmSite);
                }
            });
        }
        return notLoadedPtmSite;
    }

    protected void resetPrevPTMTaskId() {
        this.m_previousPTMTaskId = null;
    }

    protected void loadPtmSite(List<PTMSite> notLoadedPtmSite) {
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                AbstractDataBoxPTMPeptides.this.setLoaded(loadingId);
                if (!success) {
                    ((PTMPeptidesTablePanel)AbstractDataBoxPTMPeptides.this.getDataBoxPanelInterface()).setData(null, null, null, null, finished);
                } else {
                    AbstractDataBoxPTMPeptides.this.m_previousPTMTaskId = null;
                    AbstractDataBoxPTMPeptides.this.unregisterTask(taskId);
                    if (AbstractDataBoxPTMPeptides.this.m_isXICResult) {
                        AbstractDataBoxPTMPeptides.this.loadXicAndPropagate();
                    } else {
                        ((PTMPeptidesTablePanel)AbstractDataBoxPTMPeptides.this.getDataBoxPanelInterface()).setData(null, AbstractDataBoxPTMPeptides.this.m_ptmPepInstances, AbstractDataBoxPTMPeptides.this.m_ptmClusters, null, finished);
                        AbstractDataBoxPTMPeptides.this.addDataChanged(PTMPeptideInstance.class, null);
                        AbstractDataBoxPTMPeptides.this.addDataChanged(ExtendedTableModelInterface.class);
                        AbstractDataBoxPTMPeptides.this.propagateDataChanged();
                    }
                }
            }
        };
        DatabasePTMSitesTask task = new DatabasePTMSitesTask(callback);
        task.initFillPTMSites(this.getProjectId(), this.m_rsm, notLoadedPtmSite);
        Long taskId = task.getId();
        if (this.m_previousPTMTaskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousPTMTaskId);
        }
        this.m_previousPTMTaskId = taskId;
        this.registerTask((AbstractDatabaseTask)task);
    }

    protected abstract DPeptideMatch getSelectedPeptideMatch();

    protected abstract PTMPeptideInstance getSelectedPTMPeptide();

    protected abstract void setSelectedPTMPeptide(PTMPeptideInstance var1);

    public abstract void updateData();

    protected abstract void loadXicAndPropagate();

    protected abstract ArrayList<Integer> getSelectedIndex();
}

