/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPTMPeptides;
import fr.proline.studio.pattern.DataboxGraphics;
import fr.proline.studio.pattern.DataboxMultiGraphics;
import fr.proline.studio.rsmexplorer.gui.dialog.DataBoxChooserDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.windows.WindowManager;

public class AddDataBoxActionListener
implements ActionListener {
    private final SplittedPanelContainer m_splittedPanel;
    private final AbstractDataBox m_previousDatabox;

    public AddDataBoxActionListener(SplittedPanelContainer splittedPanel, AbstractDataBox previousDatabox) {
        this.m_splittedPanel = splittedPanel;
        this.m_previousDatabox = previousDatabox;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DataBoxChooserDialog dialog = new DataBoxChooserDialog(WindowManager.getDefault().getMainWindow(), this.m_previousDatabox, false, null);
        dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            AbstractDataBox genericDatabox = dialog.getSelectedDataBox();
            try {
                AbstractDataBox newGenericDatabox = (AbstractDataBox)genericDatabox.getClass().newInstance();
                if (DataboxGraphics.class.isInstance(newGenericDatabox)) {
                    ((DataboxGraphics)newGenericDatabox).setDefaultLocked(((DataboxGraphics)genericDatabox).isDefaultLocked());
                } else if (DataboxMultiGraphics.class.isInstance(newGenericDatabox)) {
                    newGenericDatabox = new DataboxMultiGraphics(false, false, ((DataboxMultiGraphics)genericDatabox).isDoubleYAxis());
                } else if (DataBoxPTMPeptides.class.equals(newGenericDatabox.getClass())) {
                    newGenericDatabox = new DataBoxPTMPeptides(((DataBoxPTMPeptides)genericDatabox).isQuantiResult(), ((DataBoxPTMPeptides)genericDatabox).isAllPSMsDisplayed());
                }
                genericDatabox = newGenericDatabox;
            }
            catch (IllegalAccessException | InstantiationException newGenericDatabox) {
                // empty catch block
            }
            this.m_previousDatabox.addNextDataBox(genericDatabox);
            genericDatabox.createPanel();
            if (dialog.addBelow()) {
                this.m_splittedPanel.registerAddedPanel((JComponent)((JPanel)((Object)genericDatabox.getPanel())));
            } else if (dialog.addTabbed()) {
                this.m_splittedPanel.registerAddedPanelAsTab((JComponent)((JPanel)((Object)genericDatabox.getPanel())));
            } else {
                this.m_splittedPanel.registerAddedPanelAsSplitted((JComponent)((JPanel)((Object)genericDatabox.getPanel())));
            }
            final AbstractDataBox _genericDatabox = genericDatabox;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    _genericDatabox.dataChanged();
                }
            });
        }
    }
}

