/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.DatabasePTMsTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.data.ptm.AggregatedMasterQuantPeptide;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMDataset;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadLcMSTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.PTMClustersPanel;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.types.XicMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBoxPTMClusters
extends AbstractDataBox {
    private final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.ptm");
    private boolean m_loadSitesAsClusters;
    private long logStartTime;
    private PTMDataset m_ptmDataset;
    private ResultSummary m_rsm;
    private QuantChannelInfo m_quantChannelInfo;
    private boolean m_isXicResult = false;
    private boolean m_loadPepMatchOnGoing = false;

    public DataBoxPTMClusters() {
        super(AbstractDataBox.DataboxType.DataBoxPTMClusters, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_typeName = "Dataset PTMs Clusters";
        this.m_description = "Clusters of Modification Sites of a Dataset";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(PTMDataset.class);
        inParameter.addParameter(DDataset.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(ResultSummary.class);
        outParameter.addParameter(PTMPeptideInstance.class, ParameterSubtypeEnum.LEAF_PTMPeptideInstance);
        outParameter.addParameter(PTMPeptideInstance.class, ParameterSubtypeEnum.PARENT_PTMPeptideInstance);
        outParameter.addParameter(PTMDataset.class);
        outParameter.addParameter(DProteinMatch.class);
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(PTMCluster.class, ParameterSubtypeEnum.LIST_DATA);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        outParameter.addParameter(CrossSelectionInterface.class);
        this.registerOutParameter(outParameter);
    }

    public void setViewSitesOnly(boolean viewSitesAsClusters) {
        this.m_loadSitesAsClusters = viewSitesAsClusters;
        if (this.m_loadSitesAsClusters) {
            this.m_typeName = "Dataset PTMs Sites";
        }
    }

    private boolean isXicResult() {
        return this.m_isXicResult;
    }

    public void setXicResult(boolean isXICResult) {
        this.m_isXicResult = isXICResult;
        AbstractDataBox.DataboxStyle databoxStyle = this.m_style = this.m_isXicResult ? AbstractDataBox.DataboxStyle.STYLE_XIC : AbstractDataBox.DataboxStyle.STYLE_SC;
        if (this.m_isXicResult) {
            this.registerXicOutParameter();
        }
    }

    private void registerXicOutParameter() {
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DMasterQuantProteinSet.class);
        outParameter.addParameter(DProteinSet.class);
        outParameter.addParameter(QuantChannelInfo.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public Long getRsetId() {
        if (this.m_ptmDataset == null) {
            return null;
        }
        return this.m_ptmDataset.getDataset().getResultSetId();
    }

    @Override
    public Long getRsmId() {
        if (this.m_ptmDataset == null) {
            return null;
        }
        return this.m_ptmDataset.getDataset().getResultSummaryId();
    }

    @Override
    public void createPanel() {
        PTMClustersPanel p = new PTMClustersPanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        this.linkCache((TransientDataInterface)this.m_rsm);
        final int loadingId = this.setLoading();
        final long logStartTimelocal = System.currentTimeMillis();
        final ArrayList ptmDS = new ArrayList();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                DataBoxPTMClusters.this.m_logger.debug("DataBoxPTMClusters : **** Callback task " + taskId + ", success " + success + ", finished " + finished + "; with subtask : " + (subTask != null) + ". Duration: " + (System.currentTimeMillis() - logStartTimelocal) + " TimeMillis");
                if (success) {
                    if (subTask == null) {
                        DataBoxPTMClusters.this.m_ptmDataset = (PTMDataset)ptmDS.get(0);
                        DataBoxPTMClusters.this.m_logger.debug("  -- created " + DataBoxPTMClusters.this.m_ptmDataset.getPTMClusters().size() + " PTMCluster.");
                        DataBoxPTMClusters.this.m_loadPepMatchOnGoing = true;
                        ((PTMClustersPanel)DataBoxPTMClusters.this.getDataBoxPanelInterface()).setData(taskId, (ArrayList)DataBoxPTMClusters.this.m_ptmDataset.getPTMClusters(), finished);
                        DataBoxPTMClusters.this.loadPeptideMatches();
                    }
                } else {
                    DataBoxPTMClusters.this.displayLoadError(taskId, finished);
                }
                if (finished) {
                    DataBoxPTMClusters.this.setLoaded(loadingId);
                    DataBoxPTMClusters.this.unregisterTask(taskId);
                    DataBoxPTMClusters.this.m_logger.debug(" Task " + taskId + " DONE. Should propagate changes ");
                    DataBoxPTMClusters.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxPTMClusters.this.propagateDataChanged();
                }
            }
        };
        DatabasePTMsTask task = new DatabasePTMsTask(callback);
        task.initLoadPTMDataset(Long.valueOf(this.getProjectId()), this.m_ptmDataset.getDataset(), ptmDS, this.m_loadSitesAsClusters);
        this.m_logger.debug("DataBoxPTMClusters : **** Register task DatabasePTMsTask.initLoadPTMDataset. ID= " + task.getId());
        this.registerTask((AbstractDatabaseTask)task);
    }

    private void displayLoadError(long taskId, boolean isFinished) {
        TaskInfo ti = this.getTaskInfo(taskId);
        TaskError taskError = ti.getTaskError();
        if (taskError != null) {
            if (taskError.getErrorTitle().equals("PTM Cluster Loading Error")) {
                JOptionPane.showMessageDialog((JPanel)((Object)this.getDataBoxPanelInterface()), "To display Modification Sites or Modification Clusters, you must run \"Identify Modification Sites\" beforehand.", taskError.getErrorTitle(), 2);
            } else {
                JOptionPane.showMessageDialog((JPanel)((Object)this.getDataBoxPanelInterface()), taskError.getErrorText(), "PTM Cluster Loading Error", 0);
            }
        }
        ((PTMClustersPanel)this.getDataBoxPanelInterface()).setData(taskId, null, isFinished);
    }

    private void loadPeptideMatches() {
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                DataBoxPTMClusters.this.m_logger.debug("DataBoxPTMClusters : **** Callback task " + taskId + ", success " + success + ", finished " + finished + "; with subtask : " + subTask + ". Duration: " + (System.currentTimeMillis() - DataBoxPTMClusters.this.logStartTime) + " TimeMillis");
                if (!success) {
                    DataBoxPTMClusters.this.displayLoadError(taskId, finished);
                }
                if (finished) {
                    DataBoxPTMClusters.this.m_loadPepMatchOnGoing = false;
                    DataBoxPTMClusters.this.m_logger.debug(" Task " + taskId + " DONE. Should propagate changes or get Xic DATA ");
                    DataBoxPTMClusters.this.m_ptmDataset.updateParentPTMPeptideInstanceClusters();
                    if (DataBoxPTMClusters.this.isXicResult()) {
                        DataBoxPTMClusters.this.loadXicData(loadingId);
                    } else {
                        DataBoxPTMClusters.this.setLoaded(loadingId);
                        ((PTMClustersPanel)DataBoxPTMClusters.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                        DataBoxPTMClusters.this.addDataChanged(PTMPeptideInstance.class, null);
                        DataBoxPTMClusters.this.addDataChanged(ExtendedTableModelInterface.class);
                        DataBoxPTMClusters.this.propagateDataChanged();
                    }
                    DataBoxPTMClusters.this.unregisterTask(taskId);
                }
            }
        };
        DatabasePTMsTask task = new DatabasePTMsTask(callback);
        task.initFillPTMSites(this.getProjectId(), this.m_ptmDataset, this.m_ptmDataset.getPTMSites());
        this.logStartTime = System.currentTimeMillis();
        this.m_logger.debug("DataBoxPTMClusters : **** Register task DatabasePTMsTask.initFillPTMSites. ID= " + task.getId());
        this.registerTask((AbstractDatabaseTask)task);
    }

    public void loadXicData(final int loadingId) {
        final ArrayList m_masterQuantProteinSetList = new ArrayList();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                DataBoxPTMClusters.this.m_logger.debug("DataBoxPTMClusters : **** Callback task " + taskId + ", success " + success + ", finished " + finished + "; with subtask : " + subTask + "; found " + m_masterQuantProteinSetList.size() + " mqPrS Duration: " + (System.currentTimeMillis() - DataBoxPTMClusters.this.logStartTime) + " TimeMillis");
                if (subTask == null) {
                    DataBoxPTMClusters.this.m_quantChannelInfo = new QuantChannelInfo(DataBoxPTMClusters.this.m_ptmDataset.getDataset());
                    DataBoxPTMClusters.this.getDataBoxPanelInterface().addSingleValue(DataBoxPTMClusters.this.m_quantChannelInfo);
                    AbstractDatabaseCallback mapCallback = new AbstractDatabaseCallback(){

                        public boolean mustBeCalledInAWT() {
                            return true;
                        }

                        public void run(boolean success, long task2Id, SubTask subTask, boolean finished) {
                            DataBoxPTMClusters.this.m_logger.info("**** +++ END task " + task2Id + " if finished ? " + finished);
                            if (finished) {
                                DataBoxPTMClusters.this.unregisterTask(task2Id);
                            }
                        }
                    };
                    DatabaseLoadLcMSTask taskMap = new DatabaseLoadLcMSTask(mapCallback);
                    taskMap.initLoadAlignmentForXic(DataBoxPTMClusters.this.getProjectId(), DataBoxPTMClusters.this.m_ptmDataset.getDataset());
                    DataBoxPTMClusters.this.m_logger.info("DataBoxPTMClusters **** +++ Register task DatabaseLoadLcMSTask.initLoadAlignmentForXic " + taskMap.getId());
                    DataBoxPTMClusters.this.registerTask((AbstractDatabaseTask)taskMap);
                }
                if (finished) {
                    DataBoxPTMClusters.this.m_logger.info(" **** +++ Unregister " + taskId + " + loadProteinMatchMapping + propagate and set Loaded");
                    DataBoxPTMClusters.this.setLoaded(loadingId);
                    Map typicalProteinMatchIdByProteinMatchId = DataBoxPTMClusters.this.loadProteinMatchMapping();
                    DataBoxPTMClusters.this.m_ptmDataset.setQuantProteinSets(m_masterQuantProteinSetList, typicalProteinMatchIdByProteinMatchId);
                    DataBoxPTMClusters.this.unregisterTask(taskId);
                    DataBoxPTMClusters.this.startLoadingMasterQuantPeptides(DataBoxPTMClusters.this.m_ptmDataset.getPTMClusters());
                    DataBoxPTMClusters.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxPTMClusters.this.propagateDataChanged();
                }
            }
        };
        DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
        task.initLoadProteinSets(this.getProjectId(), this.m_ptmDataset.getDataset(), m_masterQuantProteinSetList);
        this.logStartTime = System.currentTimeMillis();
        this.m_logger.debug("DataBoxPTMClusters : ****Register task XicMasterQuantTask - initLoadProteinSets. ID = " + task.getId());
        this.registerTask((AbstractDatabaseTask)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Long> loadProteinMatchMapping() {
        HashMap<Long, Long> typicalProteinMatchIdByProteinMatchId = new HashMap<Long, Long>();
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.getProjectId()).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            long start = System.currentTimeMillis();
            Query proteinMatchQuery = entityManagerMSI.createQuery("SELECT pspmi.proteinMatch.id, pspmi.proteinSet.representativeProteinMatchId FROM ProteinSetProteinMatchItem pspmi WHERE pspmi.resultSummary.id=:rsmId");
            proteinMatchQuery.setParameter("rsmId", (Object)this.m_ptmDataset.getDataset().getResultSummaryId());
            List resultList = proteinMatchQuery.getResultList();
            for (Object[] cur : resultList) {
                Long proteinMatchId = (Long)cur[0];
                Long typicalProteinMatchId = (Long)cur[1];
                typicalProteinMatchIdByProteinMatchId.put(proteinMatchId, typicalProteinMatchId);
            }
            this.m_logger.info("Protein match ids map retrieve {} entries in {} ms", (Object)typicalProteinMatchIdByProteinMatchId.size(), (Object)(System.currentTimeMillis() - start));
            entityManagerMSI.getTransaction().commit();
        }
        return typicalProteinMatchIdByProteinMatchId;
    }

    private void startLoadingMasterQuantPeptides(final List<PTMCluster> proteinPTMClusters) {
        this.m_logger.debug("start loading MQPeptides from PTMCluster and compute PTMCluster expression values");
        final ArrayList masterQuantPeptideList = new ArrayList();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (finished) {
                    DataBoxPTMClusters.this.unregisterTask(taskId);
                    DataBoxPTMClusters.this.m_logger.info("MQPeptides loaded !! ");
                    DMasterQuantitationChannel masterQC = (DMasterQuantitationChannel)((PTMCluster)proteinPTMClusters.get(0)).getPTMDataset().getDataset().getMasterQuantitationChannels().get(0);
                    Map<Long, DMasterQuantPeptide> mqPepById = masterQuantPeptideList.stream().collect(Collectors.toMap(x -> x.getPeptideInstanceId(), x -> x));
                    for (PTMCluster currentCluster : proteinPTMClusters) {
                        if (currentCluster.getMasterQuantProteinSet() == null) continue;
                        List parentPeptideInstances = currentCluster.getParentPeptideInstances();
                        Long bestPepMatchPepId = currentCluster.getRepresentativePepMatch().getPeptide().getId();
                        Optional<DPeptideInstance> parentBestPepI = parentPeptideInstances.stream().filter(peI -> bestPepMatchPepId.equals(peI.getPeptideId())).findFirst();
                        if (parentBestPepI.isPresent()) {
                            DMasterQuantPeptide mqPep = mqPepById.get(parentBestPepI.get().getId());
                            currentCluster.setRepresentativeMQPepMatch(mqPep);
                        }
                        List mqPeps = parentPeptideInstances.stream().map(parentPepI -> (DMasterQuantPeptide)mqPepById.get(parentPepI.getId())).filter(mqp -> mqp != null).collect(Collectors.toList());
                        currentCluster.setRepresentativeMQPepMatch((DMasterQuantPeptide)new AggregatedMasterQuantPeptide(mqPeps, masterQC));
                    }
                    ((PTMClustersPanel)DataBoxPTMClusters.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
            }
        };
        DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
        List<Long> parentPepInstanceIds = proteinPTMClusters.stream().flatMap(cluster -> cluster.getParentPeptideInstances().stream()).map(pepInstance -> pepInstance.getId()).distinct().collect(Collectors.toList());
        this.m_logger.info("Loading {} peptideInstances XIC data", (Object)parentPepInstanceIds.size());
        task.initLoadPeptides(this.getProjectId(), this.m_ptmDataset.getDataset(), parentPepInstanceIds.toArray(new Long[parentPepInstanceIds.size()]), masterQuantPeptideList, true);
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null) {
            if (parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
                PTMCluster cluster2;
                if (parameterType.equals(ResultSummary.class)) {
                    return this.m_rsm;
                }
                if (parameterType.equals(DProteinMatch.class) && (cluster2 = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster()) != null) {
                    return cluster2.getProteinMatch();
                }
                if (parameterType.equals(DPeptideMatch.class) && (cluster2 = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster()) != null) {
                    return cluster2.getRepresentativePepMatch();
                }
                if (parameterType.equals(PTMDataset.class)) {
                    return this.m_ptmDataset;
                }
                if (parameterType.equals(DDataset.class)) {
                    return this.m_ptmDataset.getDataset();
                }
                if (parameterType.equals(DMasterQuantProteinSet.class) && this.isXicResult() && (cluster2 = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster()) != null) {
                    return cluster2.getMasterQuantProteinSet();
                }
                if (parameterType.equals(DProteinSet.class) && this.isXicResult() && (cluster2 = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster()) != null && cluster2.getMasterQuantProteinSet() != null) {
                    return cluster2.getMasterQuantProteinSet().getProteinSet();
                }
                if (parameterType.equals(QuantChannelInfo.class) && this.isXicResult()) {
                    return this.m_quantChannelInfo;
                }
                if (parameterType.equals(ExtendedTableModelInterface.class)) {
                    return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
                }
                if (parameterType.equals(CrossSelectionInterface.class)) {
                    return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
                }
                if (parameterType.equals(XicMode.class) && this.m_ptmDataset.getDataset().isQuantitation()) {
                    return new XicMode(true);
                }
            }
            if (parameterSubtype == ParameterSubtypeEnum.LIST_DATA && parameterType.equals(PTMCluster.class)) {
                List<PTMCluster> clusters = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedPTMClusters();
                return clusters;
            }
            if (parameterType.equals(PTMPeptideInstance.class) && (parameterSubtype.equals((Object)ParameterSubtypeEnum.PARENT_PTMPeptideInstance) || parameterSubtype.equals((Object)ParameterSubtypeEnum.LEAF_PTMPeptideInstance))) {
                if (this.m_loadPepMatchOnGoing) {
                    return null;
                }
                boolean parentPTMPeptideInstance = parameterSubtype.equals((Object)ParameterSubtypeEnum.PARENT_PTMPeptideInstance);
                List<PTMCluster> clusters = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedPTMClusters();
                ArrayList ptmPeptideInstances = new ArrayList();
                if (!clusters.isEmpty()) {
                    Collections.sort(clusters);
                    Long protMatchId = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster().getProteinMatch().getId();
                    clusters.stream().filter(cluster -> protMatchId.equals(cluster.getProteinMatch().getId())).forEach(cluster -> ptmPeptideInstances.addAll(parentPTMPeptideInstance ? cluster.getParentPTMPeptideInstances() : cluster.getLeafPTMPeptideInstances()));
                }
                return ptmPeptideInstances;
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        if (DDataset.class.isInstance(data)) {
            this.m_ptmDataset = new PTMDataset((DDataset)data);
            if (this.m_ptmDataset.getDataset().getResultSummary() == null) {
                AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                        DataBoxPTMClusters.this.m_rsm = DataBoxPTMClusters.this.m_ptmDataset.getDataset().getResultSummary();
                        DataBoxPTMClusters.this.dataChanged();
                    }
                };
                DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
                task.initLoadRsetAndRsm((DDataset)data);
                AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
            } else {
                this.m_rsm = this.m_ptmDataset.getDataset().getResultSummary();
                this.dataChanged();
            }
        } else if (PTMDataset.class.isInstance(data)) {
            this.m_ptmDataset = (PTMDataset)data;
            if (this.m_ptmDataset.getDataset().getResultSummary() == null) {
                throw new IllegalArgumentException("PTMDataset not associated to a valid DDataset (empty RSM).");
            }
            this.m_rsm = this.m_ptmDataset.getDataset().getResultSummary();
            this.dataChanged();
        } else {
            throw new IllegalArgumentException("Unsupported type " + data.getClass() + ": DDataset or PTMDataset expected.");
        }
    }

    @Override
    public Class[] getImportantInParameterClass() {
        if (this.isXicResult()) {
            Class[] classList = new Class[]{DProteinMatch.class, DMasterQuantProteinSet.class};
            return classList;
        }
        Class[] classList = new Class[]{DProteinMatch.class};
        return classList;
    }

    @Override
    public String getImportantOutParameterValue() {
        DProteinMatch p = (DProteinMatch)this.getData(DProteinMatch.class);
        if (p != null) {
            return p.getAccession();
        }
        return null;
    }
}

