/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseLoadPeptidesInstancesTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.AbstractDataBoxPTMPeptides;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.rsmexplorer.gui.ptm.PTMGraphicCtrlPanel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBoxPTMPeptidesGraphic
extends AbstractDataBoxPTMPeptides {
    private static Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.rsmexplorer.ptm");
    private Long m_previousTaskId = null;

    public DataBoxPTMPeptidesGraphic() {
        super(AbstractDataBox.DataboxType.DataBoxPTMPeptidesGraphic, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_displayAllPepMatches = false;
        this.m_isXICResult = false;
        this.m_typeName = "Graphical Peptides PTMs info";
        this.m_description = "PTMs information of Peptides of a [Group] Modification Site using graphical display.";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DProteinMatch.class);
        this.registerInParameter(inParameter);
        super.registerParameters();
    }

    @Override
    public void createPanel() {
        PTMGraphicCtrlPanel p = new PTMGraphicCtrlPanel(true);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    private void loadPeptidesInstances() {
        final DProteinMatch proteinMatch = (DProteinMatch)this.getData(DProteinMatch.class);
        ArrayList<ResultSummary> rsmList = new ArrayList<ResultSummary>(1);
        rsmList.add(this.m_rsm);
        final int loadingId = this.setLoading();
        if (this.m_previousTaskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousTaskId);
            this.m_previousTaskId = null;
        }
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                DataBoxPTMPeptidesGraphic.this.setLoaded(loadingId);
                if (success) {
                    ((PTMGraphicCtrlPanel)DataBoxPTMPeptidesGraphic.this.getDataBoxPanelInterface()).setSelectedProtein(proteinMatch);
                }
                if (finished) {
                    DataBoxPTMPeptidesGraphic.this.unregisterTask(taskId);
                }
            }
        };
        DatabaseLoadPeptidesInstancesTask task = new DatabaseLoadPeptidesInstancesTask(callback, this.getProjectId(), proteinMatch, rsmList);
        this.m_previousTaskId = task.getId();
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    protected ArrayList<Integer> getSelectedIndex() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(((PTMGraphicCtrlPanel)this.m_panel).getSelectedIndex());
        return result;
    }

    @Override
    public void updateData() {
        PTMGraphicCtrlPanel graphicView = (PTMGraphicCtrlPanel)this.getDataBoxPanelInterface();
        if (this.m_ptmPepInstances == null || this.m_ptmPepInstances.isEmpty()) {
            graphicView.setData(null);
            return;
        }
        this.loadPeptidesInstances();
        List<PTMSite> notLoadedPtmSite = this.getNotLoadedPTMSite();
        if (notLoadedPtmSite.isEmpty()) {
            this.resetPrevPTMTaskId();
            graphicView.setData(this.m_ptmPepInstances);
            this.addDataChanged(PTMPeptideInstance.class, null);
            this.propagateDataChanged();
        } else {
            this.loadPtmSite(notLoadedPtmSite);
        }
    }

    @Override
    protected void setSelectedPTMPeptide(PTMPeptideInstance pepInstance) {
        if (pepInstance != null) {
            ((PTMGraphicCtrlPanel)this.getDataBoxPanelInterface()).setSelectedPTMPeptide(pepInstance);
        }
    }

    @Override
    protected PTMPeptideInstance getSelectedPTMPeptide() {
        return ((PTMGraphicCtrlPanel)this.getDataBoxPanelInterface()).getSelectedPTMPeptideInstance();
    }

    @Override
    protected DPeptideMatch getSelectedPeptideMatch() {
        return ((PTMGraphicCtrlPanel)this.getDataBoxPanelInterface()).getSelectedPTMPeptideInstance().getRepresentativePepMatch(this.m_ptmClusters);
    }

    @Override
    protected void loadXicAndPropagate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

