/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseLoadPeptideMatchTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.PeptideMatchPanel;

public class DataBoxRsetPSM
extends AbstractDataBox {
    private ResultSet m_rset = null;
    private boolean m_mergedData;
    private Long m_previousTaskId = null;

    public DataBoxRsetPSM() {
        this(false);
    }

    public DataBoxRsetPSM(boolean mergedData) {
        super(AbstractDataBox.DataboxType.DataBoxRsetPSM, AbstractDataBox.DataboxStyle.STYLE_RSET);
        this.m_mergedData = mergedData;
        this.m_typeName = "PSMs";
        this.m_description = "All PSMs of a Search Result";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(ResultSet.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        PeptideMatchPanel p = new PeptideMatchPanel(false, this.m_mergedData, true, true, false);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        final ResultSet _rset = this.m_rset != null ? this.m_rset : (ResultSet)this.getData(ResultSet.class);
        this.linkCache((TransientDataInterface)_rset);
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    DPeptideMatch[] peptideMatchArray = _rset.getTransientData(null).getPeptideMatches();
                    long[] peptideMatchIdArray = _rset.getTransientData(null).getPeptideMatchIds();
                    ((PeptideMatchPanel)DataBoxRsetPSM.this.getDataBoxPanelInterface()).setData(taskId, peptideMatchArray, peptideMatchIdArray, finished);
                } else {
                    ((PeptideMatchPanel)DataBoxRsetPSM.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataBoxRsetPSM.this.setLoaded(loadingId);
                if (finished) {
                    DataBoxRsetPSM.this.unregisterTask(taskId);
                    DataBoxRsetPSM.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxRsetPSM.this.propagateDataChanged();
                }
            }
        };
        DatabaseLoadPeptideMatchTask task = new DatabaseLoadPeptideMatchTask(callback, this.getProjectId(), _rset);
        Long taskId = task.getId();
        if (this.m_previousTaskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousTaskId);
        }
        this.m_previousTaskId = taskId;
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DPeptideMatch.class)) {
                return ((PeptideMatchPanel)this.getDataBoxPanelInterface()).getSelectedPeptideMatch();
            }
            if (parameterType.equals(ResultSet.class) && this.m_rset != null) {
                return this.m_rset;
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public void setEntryData(Object data) {
        if (data instanceof ResultSet) {
            this.m_rset = (ResultSet)data;
            this.getDataBoxPanelInterface().addSingleValue(this.m_rset);
            this.dataChanged();
        } else if (data instanceof ResultSummary) {
            this.m_rset = ((ResultSummary)data).getResultSet();
            this.getDataBoxPanelInterface().addSingleValue(this.m_rset);
        }
    }

    @Override
    public Class[] getImportantInParameterClass() {
        Class[] classList = new Class[]{DPeptideMatch.class};
        return classList;
    }

    @Override
    public String getImportantOutParameterValue() {
        Peptide peptide;
        DPeptideMatch p = (DPeptideMatch)this.getData(DPeptideMatch.class);
        if (p != null && (peptide = p.getPeptide()) != null) {
            return peptide.getSequence();
        }
        return null;
    }
}

