/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseProteinSetsTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.RsmProteinSetPanel;
import java.util.HashSet;

public class DataBoxRsmAllProteinSet
extends AbstractDataBox {
    private ResultSummary m_rsm = null;
    private Long m_previousTaskId = null;
    private HashSet m_dataToBeSelected = null;

    public DataBoxRsmAllProteinSet() {
        super(AbstractDataBox.DataboxType.DataBoxRsmAllProteinSet, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_typeName = "Protein Set";
        this.m_description = "All Protein Sets of an Identification Summary";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(ResultSummary.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DProteinSet.class);
        outParameter.addParameter(ResultSummary.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        RsmProteinSetPanel p = new RsmProteinSetPanel(true);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        final ResultSummary _rsm = this.m_rsm != null ? this.m_rsm : (ResultSummary)this.getData(ResultSummary.class);
        this.linkCache((TransientDataInterface)_rsm);
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    DProteinSet[] proteinSetArray = _rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getProteinSetArray();
                    ((RsmProteinSetPanel)DataBoxRsmAllProteinSet.this.getDataBoxPanelInterface()).setData(taskId, proteinSetArray, finished);
                    if (DataBoxRsmAllProteinSet.this.m_dataToBeSelected != null) {
                        ((RsmProteinSetPanel)DataBoxRsmAllProteinSet.this.getDataBoxPanelInterface()).selectData(DataBoxRsmAllProteinSet.this.m_dataToBeSelected);
                        DataBoxRsmAllProteinSet.this.m_dataToBeSelected = null;
                    }
                } else {
                    ((RsmProteinSetPanel)DataBoxRsmAllProteinSet.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataBoxRsmAllProteinSet.this.setLoaded(loadingId);
                if (finished) {
                    DataBoxRsmAllProteinSet.this.unregisterTask(taskId);
                    DataBoxRsmAllProteinSet.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxRsmAllProteinSet.this.propagateDataChanged();
                }
            }
        };
        DatabaseProteinSetsTask task = new DatabaseProteinSetsTask(callback);
        task.initLoadProteinSets(this.getProjectId(), _rsm);
        Long taskId = task.getId();
        if (this.m_previousTaskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousTaskId);
        }
        this.m_previousTaskId = taskId;
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DProteinSet.class)) {
                return ((RsmProteinSetPanel)this.getDataBoxPanelInterface()).getSelectedProteinSet();
            }
            if (parameterType.equals(ResultSummary.class) && this.m_rsm != null) {
                return this.m_rsm;
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        this.m_rsm = (ResultSummary)data;
        this.dataChanged();
    }

    @Override
    protected void selectDataWhenLoaded(HashSet data) {
        this.m_dataToBeSelected = data;
    }

    @Override
    public Class[] getImportantInParameterClass() {
        Class[] classList = new Class[]{DProteinSet.class};
        return classList;
    }

    @Override
    public String getImportantOutParameterValue() {
        DProteinMatch pm;
        DProteinSet p = (DProteinSet)this.getData(DProteinSet.class);
        if (p != null && (pm = p.getTypicalProteinMatch()) != null) {
            return pm.getAccession();
        }
        return null;
    }
}

