/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideInstance;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseLoadPeptidesInstancesTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.RsmPeptidesPanel;

public class DataBoxRsmPeptideInstances
extends AbstractDataBox {
    ResultSummary m_rsm = null;
    private Long m_previousTaskId = null;

    public DataBoxRsmPeptideInstances() {
        super(AbstractDataBox.DataboxType.DataBoxRsmPeptideInstances, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_typeName = "Peptides";
        this.m_description = "All Peptides of an Identification Summary";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(ResultSummary.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(PeptideInstance.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        RsmPeptidesPanel p = new RsmPeptidesPanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        final ResultSummary _rsm = this.m_rsm != null ? this.m_rsm : (ResultSummary)this.getData(ResultSummary.class);
        this.linkCache((TransientDataInterface)_rsm);
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    PeptideInstance[] peptideinstanceArray = _rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getPeptideInstanceArray();
                    ((RsmPeptidesPanel)DataBoxRsmPeptideInstances.this.getDataBoxPanelInterface()).setData(taskId, peptideinstanceArray, finished);
                } else {
                    ((RsmPeptidesPanel)DataBoxRsmPeptideInstances.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataBoxRsmPeptideInstances.this.setLoaded(loadingId);
                if (finished) {
                    DataBoxRsmPeptideInstances.this.unregisterTask(taskId);
                    DataBoxRsmPeptideInstances.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxRsmPeptideInstances.this.propagateDataChanged();
                }
            }
        };
        DatabaseLoadPeptidesInstancesTask task = new DatabaseLoadPeptidesInstancesTask(callback, this.getProjectId(), _rsm);
        Long taskId = task.getId();
        if (this.m_previousTaskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousTaskId);
        }
        this.m_previousTaskId = taskId;
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(PeptideInstance.class)) {
                return ((RsmPeptidesPanel)this.getDataBoxPanelInterface()).getSelectedPeptideInstance();
            }
            if (parameterType.equals(DPeptideMatch.class)) {
                PeptideInstance pi = ((RsmPeptidesPanel)this.getDataBoxPanelInterface()).getSelectedPeptideInstance();
                if (pi == null) {
                    return null;
                }
                return pi.getTransientData().getBestPeptideMatch();
            }
            if (parameterType.equals(ResultSummary.class) && this.m_rsm != null) {
                return this.m_rsm;
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        if (data instanceof ResultSummary) {
            this.m_rsm = (ResultSummary)data;
            this.dataChanged();
        }
    }

    @Override
    public Class[] getImportantInParameterClass() {
        Class[] classList = new Class[]{PeptideInstance.class, DPeptideMatch.class};
        return classList;
    }

    @Override
    public String getImportantOutParameterValue() {
        Peptide peptide;
        DPeptideMatch p = (DPeptideMatch)this.getData(DPeptideMatch.class);
        if (p != null && (peptide = p.getPeptide()) != null) {
            return peptide.getSequence();
        }
        return null;
    }
}

