/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseLoadPeptidesInstancesTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.RsmPeptidesOfProteinPanel;
import java.util.ArrayList;

public class DataBoxRsmPeptidesOfProtein
extends AbstractDataBox {
    private Long m_previousTaskId = null;

    public DataBoxRsmPeptidesOfProtein() {
        super(AbstractDataBox.DataboxType.DataBoxRsmPeptidesOfProtein, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_typeName = "Peptides";
        this.m_description = "All Peptides of a Protein Match";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DProteinMatch.class);
        inParameter.addParameter(ResultSummary.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DPeptideInstance.class);
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        RsmPeptidesOfProteinPanel p = new RsmPeptidesOfProteinPanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        final DProteinMatch proteinMatch = (DProteinMatch)this.getData(DProteinMatch.class);
        final DPeptideMatch peptideMatch = (DPeptideMatch)this.getData(DPeptideMatch.class);
        final ResultSummary rsm = (ResultSummary)this.getData(ResultSummary.class);
        this.linkCache((TransientDataInterface)rsm);
        if (proteinMatch == null) {
            ((RsmPeptidesOfProteinPanel)this.getDataBoxPanelInterface()).setData(null, null, null);
            return;
        }
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success) {
                    ((RsmPeptidesOfProteinPanel)DataBoxRsmPeptidesOfProtein.this.getDataBoxPanelInterface()).setData(proteinMatch, peptideMatch, rsm);
                } else {
                    ((RsmPeptidesOfProteinPanel)DataBoxRsmPeptidesOfProtein.this.getDataBoxPanelInterface()).setData(null, null, null);
                }
                DataBoxRsmPeptidesOfProtein.this.setLoaded(loadingId);
                if (finished) {
                    DataBoxRsmPeptidesOfProtein.this.unregisterTask(taskId);
                    DataBoxRsmPeptidesOfProtein.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxRsmPeptidesOfProtein.this.propagateDataChanged();
                }
            }
        };
        ArrayList<ResultSummary> rsmList = new ArrayList<ResultSummary>(1);
        rsmList.add(rsm);
        DatabaseLoadPeptidesInstancesTask task = new DatabaseLoadPeptidesInstancesTask(callback, this.getProjectId(), proteinMatch, rsmList);
        Long taskId = task.getId();
        if (this.m_previousTaskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousTaskId);
        }
        this.m_previousTaskId = taskId;
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            DPeptideInstance pi;
            if (parameterType.equals(DPeptideInstance.class)) {
                return ((RsmPeptidesOfProteinPanel)this.getDataBoxPanelInterface()).getSelectedPeptide();
            }
            if (parameterType.equals(DPeptideMatch.class) && (pi = ((RsmPeptidesOfProteinPanel)this.getDataBoxPanelInterface()).getSelectedPeptide()) != null) {
                return pi.getBestPeptideMatch();
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public Class[] getImportantInParameterClass() {
        Class[] classList = new Class[]{DPeptideMatch.class};
        return classList;
    }

    @Override
    public String getImportantOutParameterValue() {
        Peptide peptide;
        DPeptideMatch p = (DPeptideMatch)this.getData(DPeptideMatch.class);
        if (p != null && (peptide = p.getPeptide()) != null) {
            return peptide.getSequence();
        }
        return null;
    }
}

