/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.studio.pattern.ParameterSubtypeEnum;

public class DataParameter {
    private Class m_type;
    private ParameterSubtypeEnum m_subtype;
    private boolean m_isCompulsory;

    public DataParameter(Class c, ParameterSubtypeEnum subtype) {
        this(c, subtype, true);
    }

    public DataParameter(Class c, ParameterSubtypeEnum subtype, boolean isCompulsory) {
        this.m_type = c;
        this.m_subtype = subtype;
        this.m_isCompulsory = isCompulsory;
    }

    public Class getParameterClass() {
        return this.m_type;
    }

    public ParameterSubtypeEnum getSubtype() {
        return this.m_subtype;
    }

    public boolean equals(Object p) {
        if (p instanceof DataParameter) {
            return this.m_type.equals(((DataParameter)p).m_type);
        }
        return false;
    }

    public boolean equalsData(Class dataC, ParameterSubtypeEnum subtype) {
        return this.m_type.equals(dataC) && (subtype == null || this.m_subtype == null || this.m_subtype.equals((Object)subtype));
    }

    public boolean isCompatibleWithOutParameter(DataParameter outParameter) {
        if (!this.m_type.equals(outParameter.m_type)) {
            return false;
        }
        if (this.m_subtype == null && outParameter.m_subtype == null) {
            return true;
        }
        if (this.m_subtype == null || outParameter.m_subtype == null) {
            return false;
        }
        return this.m_subtype.equals((Object)outParameter.m_subtype);
    }

    public boolean isCompulsory() {
        return this.m_isCompulsory;
    }

    public int hashCode() {
        return this.m_type.hashCode();
    }
}

