/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.studio.gui.OptionDialog;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.WindowSavedManager;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.openide.windows.WindowManager;

public class SaveDataBoxActionListener
implements ActionListener {
    private SplittedPanelContainer m_splittedPanel;

    public SaveDataBoxActionListener(SplittedPanelContainer splittedPanel) {
        this.m_splittedPanel = splittedPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String windowName = this.showSelectNameDialog();
        if (windowName == null) {
            return;
        }
        String windowSaved = SaveDataBoxActionListener.saveSplittedPanelContainer(windowName, this.m_splittedPanel);
        WindowSavedManager.addSavedWindow(windowSaved);
    }

    public static String saveParentContainer(String windowName, Container c) {
        while (c != null && !(c instanceof SplittedPanelContainer)) {
            c = c.getParent();
        }
        if (c == null) {
            return null;
        }
        return SaveDataBoxActionListener.saveSplittedPanelContainer(windowName, (SplittedPanelContainer)c);
    }

    public static String saveSplittedPanelContainer(String windowName, SplittedPanelContainer splittedPanel) {
        if ((windowName = windowName.trim()).indexOf(35) != -1) {
            windowName.replaceAll("#", "_");
        }
        ArrayList panelList = new ArrayList();
        ArrayList<SplittedPanelContainer.PanelLayout> layoutList = new ArrayList<SplittedPanelContainer.PanelLayout>();
        splittedPanel.generateListOfPanels(panelList, layoutList);
        ArrayList<AbstractDataBox> boxList = new ArrayList<AbstractDataBox>();
        for (int i = 0; i < panelList.size(); ++i) {
            JPanel p = (JPanel)panelList.get(i);
            if (!(p instanceof DataBoxPanelInterface)) continue;
            DataBoxPanelInterface databoxPanelInterface = (DataBoxPanelInterface)((Object)p);
            AbstractDataBox b = databoxPanelInterface.getDataBox();
            boxList.add(b);
        }
        String windowSaved = WindowSavedManager.writeBoxes(windowName, boxList, layoutList);
        return windowSaved;
    }

    private String showSelectNameDialog() {
        OptionDialog dialog = new OptionDialog((Window)WindowManager.getDefault().getMainWindow(), "Select Window Name", null, "Window Name", OptionDialog.OptionDialogType.TEXTFIELD);
        dialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
        dialog.setVisible(true);
        String newName = null;
        if (dialog.getButtonClicked() == 0) {
            newName = dialog.getText();
        }
        if (newName != null && newName.length() > 0) {
            return newName;
        }
        return null;
    }
}

