/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern.xic;

import fr.proline.core.orm.lcms.MapAlignment;
import fr.proline.core.orm.lcms.ProcessedMap;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadLcMSTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.dialog.xic.AbstractLabelFreeMSParamsPanel;
import fr.proline.studio.rsmexplorer.gui.xic.MapAlignmentPanel;
import fr.proline.studio.rsmexplorer.gui.xic.MapTimePanel;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.alignment.IonsRTTableModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataboxMapAlignment
extends AbstractDataBox {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.XIC.alignment");
    private double m_logStartTime;
    private double m_logCloudStartTime;
    private DDataset m_dataset;
    private QuantChannelInfo m_quantChannelInfo;
    private List<DMasterQuantPeptideIon> m_masterQuantPeptideIonList;
    private Map<Long, IonsRTTableModel> m_compareRT2Maps;
    private double m_RT_Tolerance;
    private Long m_paramTaskId;
    private boolean m_isCloudLoaded;
    private boolean m_isCloudTaskAsked;

    public DataboxMapAlignment() {
        super(AbstractDataBox.DataboxType.DataBoxMapAlignment, AbstractDataBox.DataboxStyle.STYLE_XIC);
        this.m_typeName = "Map Alignment Plot";
        this.m_description = "Graphical display of XIC Map Alignment.";
        this.m_compareRT2Maps = new HashMap<Long, IonsRTTableModel>();
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DDataset.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(ExtendedTableModelInterface.class, ParameterSubtypeEnum.LIST_DATA);
        outParameter.addParameter(CrossSelectionInterface.class, ParameterSubtypeEnum.LIST_DATA);
        this.registerOutParameter(outParameter);
        this.m_RT_Tolerance = 0.0;
        this.m_isCloudLoaded = false;
        this.m_isCloudTaskAsked = false;
    }

    public double getRT_Tolerance() {
        return this.m_RT_Tolerance;
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.LIST_DATA) {
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return this.getCompareDataInterfaceList();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return this.getCrossSelectionInterfaceList();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    private List<ExtendedTableModelInterface> getCompareDataInterfaceList() {
        ArrayList<ExtendedTableModelInterface> listCDI = new ArrayList<ExtendedTableModelInterface>();
        List<MapTimePanel> listMapTimePanel = this.getMapTimeTableModelList();
        for (MapTimePanel mapTimePanel : listMapTimePanel) {
            listCDI.add((ExtendedTableModelInterface)mapTimePanel.getGlobalTableModelInterface());
        }
        return listCDI;
    }

    private List<CrossSelectionInterface> getCrossSelectionInterfaceList() {
        ArrayList<CrossSelectionInterface> listCSI = new ArrayList<CrossSelectionInterface>();
        List<MapTimePanel> listMapTimePanel = this.getMapTimeTableModelList();
        for (MapTimePanel mapTimePanel : listMapTimePanel) {
            listCSI.add(mapTimePanel.getCrossSelectionInterface());
        }
        return listCSI;
    }

    private List<MapTimePanel> getMapTimeTableModelList() {
        ArrayList<MapTimePanel> list = new ArrayList<MapTimePanel>();
        for (MapAlignment mapAlignment : this.m_dataset.getMapAlignmentsFromMap(this.m_dataset.getAlnReferenceMapId())) {
            List listMapTime = mapAlignment.getMapTimeList();
            MapTimePanel mapTimePanel = new MapTimePanel();
            String fromMap = this.m_quantChannelInfo.getMapTitle(mapAlignment.getSourceMap().getId());
            String toMap = this.m_quantChannelInfo.getMapTitle(mapAlignment.getDestinationMap().getId());
            String title = "Map Alignment from " + fromMap + " (to " + toMap + ")";
            Color color = this.m_quantChannelInfo.getMapColor(mapAlignment.getDestinationMap().getId());
            mapTimePanel.setData(-1L, mapAlignment, listMapTime, color, title, true, fromMap);
            list.add(mapTimePanel);
        }
        return list;
    }

    @Override
    public void createPanel() {
        MapAlignmentPanel p = new MapAlignmentPanel(this);
        p.setName(this.m_typeName);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        this.m_dataset = (DDataset)data;
        this.dataChanged();
    }

    @Override
    public void dataChanged() {
        final int loadingId = this.setLoading();
        if (this.m_dataset == null) {
            this.m_dataset = (DDataset)this.getData(DDataset.class);
        }
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                DataboxMapAlignment.this.setLoaded(loadingId);
                if (finished) {
                    logger.debug("DataboxMapAlignment task Id =" + taskId + " finished during " + ((double)System.currentTimeMillis() - DataboxMapAlignment.this.m_logStartTime) + " TimeMillis");
                    DataboxMapAlignment.this.unregisterTask(taskId);
                }
                if (taskId != DataboxMapAlignment.this.m_paramTaskId) {
                    DataboxMapAlignment.this.m_quantChannelInfo = new QuantChannelInfo(DataboxMapAlignment.this.m_dataset);
                    ((MapAlignmentPanel)DataboxMapAlignment.this.getDataBoxPanelInterface()).setData(DataboxMapAlignment.this.m_quantChannelInfo, DataboxMapAlignment.this.getCompareDataInterfaceList(), DataboxMapAlignment.this.getCrossSelectionInterfaceList());
                    if (finished) {
                        DataboxMapAlignment.this.addDataChanged(ExtendedTableModelInterface.class, ParameterSubtypeEnum.LIST_DATA);
                        DataboxMapAlignment.this.propagateDataChanged();
                    }
                }
            }
        };
        DatabaseLoadXicMasterQuantTask taskParameter = new DatabaseLoadXicMasterQuantTask(callback);
        taskParameter.initLoadQuantChannels(this.getProjectId(), this.m_dataset);
        DatabaseLoadLcMSTask taskMapAlignment = new DatabaseLoadLcMSTask(callback);
        taskMapAlignment.initLoadAlignmentForXic(this.getProjectId(), this.m_dataset);
        this.m_paramTaskId = taskParameter.getId();
        this.m_logStartTime = System.currentTimeMillis();
        logger.debug(this.getClass().getName() + " DatabaseLoadXicMasterQuantTask taskParameter Id =" + this.m_paramTaskId + " registered");
        logger.debug(this.getClass().getName() + " DatabaseLoadLcMSTask taskMapAlignment Id =" + taskMapAlignment.getId() + " registered");
        this.registerTask((AbstractDatabaseTask)taskParameter);
        this.registerTask((AbstractDatabaseTask)taskMapAlignment);
    }

    public void loadCloud() {
        if (this.m_isCloudLoaded) {
            ((MapAlignmentPanel)super.getDataBoxPanelInterface()).setAlignmentCloud();
        } else {
            if (this.m_isCloudTaskAsked) {
                return;
            }
            this.m_isCloudTaskAsked = true;
            final int loadingId = this.setLoading();
            if (this.m_dataset == null) {
                this.m_dataset = (DDataset)this.getData(DDataset.class);
            }
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (taskId != DataboxMapAlignment.this.m_paramTaskId && finished) {
                        DataboxMapAlignment.this.setLoaded(loadingId);
                        DataboxMapAlignment.this.unregisterTask(taskId);
                        logger.debug("DataboxMapAlignment task Id =" + taskId + " finished during " + ((double)System.currentTimeMillis() - DataboxMapAlignment.this.m_logCloudStartTime) + " TimeMillis");
                        if (DataboxMapAlignment.this.isLoaded()) {
                            DataboxMapAlignment.this.m_isCloudLoaded = true;
                            DataboxMapAlignment.this.m_RT_Tolerance = DataboxMapAlignment.this.getTimeTol();
                            ((MapAlignmentPanel)DataboxMapAlignment.this.getPanel()).setAlignmentCloud();
                        }
                    }
                }
            };
            this.m_masterQuantPeptideIonList = new ArrayList<DMasterQuantPeptideIon>();
            DatabaseLoadXicMasterQuantTask taskPeptideCloud = new DatabaseLoadXicMasterQuantTask(callback);
            taskPeptideCloud.initLoadPeptideIons(this.getProjectId(), this.m_dataset, this.m_masterQuantPeptideIonList);
            this.m_logCloudStartTime = System.currentTimeMillis();
            logger.debug(this.getClass().getName() + " DatabaseLoadLcMSTask taskPeptideCloud Id =" + taskPeptideCloud.getId() + " registered");
            this.registerTask((AbstractDatabaseTask)taskPeptideCloud);
        }
    }

    private double getTimeTol() {
        Double time = AbstractLabelFreeMSParamsPanel.DEFAULT_CA_FEATMAP_RTTOL_VALUE;
        try {
            Map crossAssignmentConfig;
            Map ftMappingParams;
            Map quantParams = this.m_dataset.getQuantProcessingConfigAsMap();
            if (quantParams.containsKey("cross_assignment_config") && (time = Double.valueOf((String)(ftMappingParams = (Map)(crossAssignmentConfig = (Map)quantParams.get("cross_assignment_config")).getOrDefault("ft_mapping_params", new HashMap())).get("time_tol"))) == null) {
                time = AbstractLabelFreeMSParamsPanel.DEFAULT_CA_FEATMAP_RTTOL_VALUE;
            }
        }
        catch (Exception ex) {
            logger.error("error while get Tolerence RT Time " + ex);
        }
        return time;
    }

    public IonsRTTableModel getPeptideCloud(long mapIdFrom) {
        IonsRTTableModel listETI = this.m_compareRT2Maps.get(mapIdFrom);
        if (listETI == null) {
            listETI = this.createMapRTCompareTableModel(mapIdFrom);
            this.m_compareRT2Maps.put(mapIdFrom, listETI);
        }
        return listETI;
    }

    private IonsRTTableModel createMapRTCompareTableModel(long mapIdFrom) {
        HashMap<Long, String> idNameMap = new HashMap<Long, String>();
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        List processMapList = this.m_quantChannelInfo.getDataset().getMaps();
        long[] rsmIdArray = new long[processMapList.size()];
        int index = 1;
        for (ProcessedMap map : processMapList) {
            Long mapId = map.getId();
            String mapTitle = this.m_quantChannelInfo.getMapTitle(mapId);
            Long rsmId = this.m_quantChannelInfo.getQuantChannelForMap(mapId).getId();
            idMap.put(mapId, rsmId);
            idNameMap.put(rsmId, mapTitle);
            if (mapId == mapIdFrom) {
                rsmIdArray[0] = rsmId;
                continue;
            }
            rsmIdArray[index] = rsmId;
            ++index;
        }
        IonsRTTableModel cloud = new IonsRTTableModel(this.m_masterQuantPeptideIonList, idMap, idNameMap, rsmIdArray);
        return cloud;
    }
}

