/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern.xic;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.xic.ProteinQuantPanel;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.XicProteinSetPanel;
import fr.proline.studio.types.XicMode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataboxXicProteinSet
extends AbstractDataBox {
    private static final Logger m_logger = LoggerFactory.getLogger(DataboxXicProteinSet.class);
    private DDataset m_dataset;
    private QuantChannelInfo m_quantChannelInfo;
    private List<DMasterQuantProteinSet> m_masterQuantProteinSetList;
    private boolean m_isXICMode = true;

    public DataboxXicProteinSet() {
        super(AbstractDataBox.DataboxType.DataboxXicProteinSet, AbstractDataBox.DataboxStyle.STYLE_XIC);
        this.m_typeName = "Quanti Protein Sets";
        this.m_description = "All Protein Sets of a Quantitation";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DDataset.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DDataset.class);
        outParameter.addParameter(ResultSummary.class);
        outParameter.addParameter(DProteinSet.class);
        outParameter.addParameter(DMasterQuantProteinSet.class);
        outParameter.addParameter(QuantChannelInfo.class);
        outParameter.addParameter(XicMode.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        outParameter.addParameter(ExtendedTableModelInterface.class, ParameterSubtypeEnum.LIST_DATA);
        outParameter.addParameter(CrossSelectionInterface.class);
        this.registerOutParameter(outParameter);
    }

    public boolean isXICMode() {
        return this.m_isXICMode;
    }

    public void setXICMode(boolean isXICMode) {
        this.m_isXICMode = isXICMode;
        AbstractDataBox.DataboxStyle databoxStyle = this.m_style = this.m_isXICMode ? AbstractDataBox.DataboxStyle.STYLE_XIC : AbstractDataBox.DataboxStyle.STYLE_SC;
        if (this.getDataBoxPanelInterface() != null) {
            this.getDataBoxPanelInterface().addSingleValue(new XicMode(isXICMode));
        }
    }

    @Override
    public Long getRsetId() {
        if (this.m_dataset != null) {
            return this.m_dataset.getResultSetId();
        }
        return null;
    }

    @Override
    public Long getRsmId() {
        if (this.m_dataset != null) {
            return this.m_dataset.getResultSummaryId();
        }
        return null;
    }

    @Override
    public void createPanel() {
        XicProteinSetPanel p = new XicProteinSetPanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
        this.getDataBoxPanelInterface().addSingleValue(new XicMode(this.m_isXICMode));
    }

    @Override
    public void dataChanged() {
        final int loadingId = this.setLoading();
        this.linkCache((TransientDataInterface)this.m_dataset.getResultSummary());
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    DataboxXicProteinSet.this.m_quantChannelInfo = new QuantChannelInfo(DataboxXicProteinSet.this.m_dataset);
                    DataboxXicProteinSet.this.getDataBoxPanelInterface().addSingleValue(DataboxXicProteinSet.this.m_quantChannelInfo);
                    ((XicProteinSetPanel)DataboxXicProteinSet.this.getDataBoxPanelInterface()).setData(taskId, DataboxXicProteinSet.this.m_quantChannelInfo.getQuantChannels(), DataboxXicProteinSet.this.m_masterQuantProteinSetList, DataboxXicProteinSet.this.m_isXICMode, finished);
                    DataboxXicProteinSet.this.addDataChanged(ExtendedTableModelInterface.class, null);
                    DataboxXicProteinSet.this.propagateDataChanged();
                } else {
                    ((XicProteinSetPanel)DataboxXicProteinSet.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataboxXicProteinSet.this.setLoaded(loadingId);
                if (finished) {
                    DataboxXicProteinSet.this.unregisterTask(taskId);
                }
            }
        };
        this.m_masterQuantProteinSetList = new ArrayList<DMasterQuantProteinSet>();
        DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
        task.initLoadProteinSets(this.getProjectId(), this.m_dataset, this.m_masterQuantProteinSetList);
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public void dataMustBeRecalculated(Long rsetId, Long rsmId, Class dataType, ArrayList modificationsList, int reason) {
        if (this.m_dataset.getResultSetId() != rsetId) {
            return;
        }
        if (this.m_dataset.getResultSummaryId() != rsmId) {
            return;
        }
        if (dataType.equals(DMasterQuantProteinSet.class)) {
            ((XicProteinSetPanel)this.getDataBoxPanelInterface()).dataModified(modificationsList, reason);
        }
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        this.m_dataset = (DDataset)data;
        this.dataChanged();
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null) {
            if (parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
                if (parameterType.equals(ResultSummary.class)) {
                    return this.m_dataset.getResultSummary();
                }
                if (parameterType.equals(DDataset.class)) {
                    return this.m_dataset;
                }
                if (parameterType.equals(QuantChannelInfo.class)) {
                    return this.m_quantChannelInfo;
                }
                if (parameterType.equals(DProteinSet.class)) {
                    return ((XicProteinSetPanel)this.getDataBoxPanelInterface()).getSelectedProteinSet();
                }
                if (parameterType.equals(DMasterQuantProteinSet.class)) {
                    return ((XicProteinSetPanel)this.getDataBoxPanelInterface()).getSelectedMasterQuantProteinSet();
                }
                if (parameterType.equals(ExtendedTableModelInterface.class)) {
                    return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
                }
                if (parameterType.equals(CrossSelectionInterface.class)) {
                    return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
                }
                if (parameterType.equals(XicMode.class)) {
                    return new XicMode(this.isXICMode());
                }
            }
            if (parameterSubtype == ParameterSubtypeEnum.LIST_DATA) {
                if (parameterType.equals(ExtendedTableModelInterface.class)) {
                    return this.getCompareDataInterfaceList();
                }
                if (parameterType.equals(CrossSelectionInterface.class)) {
                    return this.getCrossSelectionInterfaceList();
                }
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public String getFullName() {
        if (this.m_dataset == null) {
            return super.getFullName();
        }
        return this.m_dataset.getName() + " " + this.getTypeName();
    }

    private List<ExtendedTableModelInterface> getCompareDataInterfaceList() {
        ArrayList<ExtendedTableModelInterface> listCDI = new ArrayList<ExtendedTableModelInterface>();
        ProteinQuantPanel aProtPanel = this.getProteinQuantTableModelList();
        listCDI.add((ExtendedTableModelInterface)aProtPanel.getGlobalTableModelInterface());
        return listCDI;
    }

    private List<CrossSelectionInterface> getCrossSelectionInterfaceList() {
        ArrayList<CrossSelectionInterface> listCSI = new ArrayList<CrossSelectionInterface>();
        ProteinQuantPanel aProtPanel = this.getProteinQuantTableModelList();
        listCSI.add(aProtPanel.getCrossSelectionInterface());
        return listCSI;
    }

    private ProteinQuantPanel getProteinQuantTableModelList() {
        ProteinQuantPanel aProtPanel = new ProteinQuantPanel();
        aProtPanel.setData(this.m_quantChannelInfo.getQuantChannels(), ((XicProteinSetPanel)this.getDataBoxPanelInterface()).getSelectedMasterQuantProteinSet(), this.m_isXICMode);
        return aProtPanel;
    }

    @Override
    public Class[] getImportantInParameterClass() {
        Class[] classList = new Class[]{DMasterQuantProteinSet.class, DProteinSet.class};
        return classList;
    }

    @Override
    public String getImportantOutParameterValue() {
        DProteinMatch pm;
        DProteinSet p = (DProteinSet)this.getData(DProteinSet.class);
        if (p != null && (pm = p.getTypicalProteinMatch()) != null) {
            return pm.getAccession();
        }
        return null;
    }
}

