/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer;

import fr.proline.studio.gui.OptionDialog;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.table.TableInfo;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DataBoxViewerTopComponent
extends TopComponent {
    private WindowBox m_windowBox = null;
    private boolean firstPaint = true;

    public DataBoxViewerTopComponent(WindowBox windowBox) {
        this.m_windowBox = windowBox;
        this.setLayout(new GridLayout());
        this.add(windowBox.getPanel());
        this.setName(windowBox.getName());
        this.setToolTipText(windowBox.getName());
    }

    public WindowBox getWindowBox() {
        return this.m_windowBox;
    }

    public void retrieveTableModels(ArrayList<TableInfo> list) {
        this.m_windowBox.retrieveTableModels(list);
    }

    public Action[] getActions() {
        ArrayList<Action> actionList;
        Action[] actions = super.getActions();
        AbstractAction renameAction = new AbstractAction("Rename..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionDialog dialog = new OptionDialog((Window)WindowManager.getDefault().getMainWindow(), "Rename", null, "New Name", OptionDialog.OptionDialogType.TEXTFIELD);
                dialog.setText(DataBoxViewerTopComponent.this.getName());
                Object o = e.getSource();
                dialog.setVisible(true);
                String newName = null;
                if (dialog.getButtonClicked() == 0) {
                    newName = dialog.getText();
                }
                if (newName != null && newName.length() > 0) {
                    DataBoxViewerTopComponent.this.setName(newName);
                    DataBoxViewerTopComponent.this.m_windowBox.getEntryBox().setUserName(newName);
                }
            }
        };
        if (actions == null) {
            actionList = new ArrayList<Action>(2);
            actionList.add(renameAction);
        } else {
            actionList = new ArrayList(actions.length + 2);
            actionList.add(renameAction);
            actionList.add(null);
            for (Action a : actions) {
                actionList.add(a);
            }
        }
        return actionList.toArray(new Action[0]);
    }

    protected void componentOpened() {
        this.m_windowBox.windowOpened();
    }

    protected void componentClosed() {
        this.m_windowBox.windowClosed();
    }

    public Image getIcon() {
        return this.m_windowBox.getIcon();
    }

    public int getPersistenceType() {
        return 2;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.firstPaint) {
            this.firstPaint = false;
            this.m_windowBox.resetDefaultSize();
        }
    }

    public ParameterList getInParameters() {
        return this.m_windowBox.getEntryBox().getInParameters();
    }

    public ParameterList getOutParameters() {
        return this.m_windowBox.getEntryBox().getOutParameters();
    }

    public Object getData(Class parameterType) {
        return this.getData(parameterType, ParameterSubtypeEnum.SINGLE_DATA);
    }

    public Object getData(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        return this.m_windowBox.getEntryBox().getData(parameterType, parameterSubtype);
    }

    public long getProjectId() {
        return this.m_windowBox.getEntryBox().getProjectId();
    }

    public void loadedDataModified(Long rsetId, Long rsmId, Class c, ArrayList modificationsList, int reason) {
        this.m_windowBox.getEntryBox().loadedDataModified(rsetId, rsmId, c, modificationsList, reason);
    }
}

