/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions;

import fr.proline.studio.dam.taskinfo.TaskInfoManager;
import fr.proline.studio.dpm.ServerConnectionManager;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.ServerConnectionDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ConnectAction
extends AbstractAction
implements ContextAwareAction {
    private static ConnectAction m_action = null;
    private static boolean m_connectAction;

    private ConnectAction() {
        m_action = this;
        ConnectAction.setConnectionType(true, true);
    }

    public static final void setConnectionType(boolean connectAction, boolean enabled) {
        m_connectAction = connectAction;
        if (m_action != null) {
            m_action.setEnabled(enabled);
            if (connectAction) {
                m_action.putValue("Name", NbBundle.getMessage(ConnectAction.class, (String)"CTL_ConnectAction"));
            } else {
                m_action.putValue("Name", "Change User...");
            }
        }
    }

    public Action createContextAwareInstance(Lookup lkp) {
        return new ConnectAction();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (m_connectAction) {
            ServerConnectionManager serciceConnectionMgr = ServerConnectionManager.getServerConnectionManager();
            if (serciceConnectionMgr.isNotConnected() || serciceConnectionMgr.isConnectionFailed()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ServerConnectionDialog serverConnectionDialog = ServerConnectionDialog.getDialog(WindowManager.getDefault().getMainWindow());
                        serverConnectionDialog.centerToScreen();
                        serverConnectionDialog.setVisible(true);
                        ServerConnectionManager serciceConnectionMgr = ServerConnectionManager.getServerConnectionManager();
                        if (serciceConnectionMgr.isConnectionDone()) {
                            ProjectExplorerPanel.getProjectExplorerPanel().startLoadingProjects();
                        }
                    }
                });
            } else {
                ServerConnectionDialog serverConnectionDialog = ServerConnectionDialog.getDialog(WindowManager.getDefault().getMainWindow());
                serverConnectionDialog.setChangeUser();
                serverConnectionDialog.centerToWindow(WindowManager.getDefault().getMainWindow());
                serverConnectionDialog.setVisible(true);
            }
        } else {
            if (TaskInfoManager.getTaskInfoManager().askBeforeExitingApp()) {
                InfoDialog exitDialog = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Warning", "You should not disconnect. Important tasks are being done.\nAre you sure you want to disconnect ?");
                exitDialog.setButtonName(0, "Yes");
                exitDialog.setButtonName(1, "No");
                exitDialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                exitDialog.setVisible(true);
                if (exitDialog.getButtonClicked() == 1) {
                    return;
                }
            }
            ServerConnectionDialog serverConnectionDialog = ServerConnectionDialog.getDialog(WindowManager.getDefault().getMainWindow());
            serverConnectionDialog.setChangeUser();
            serverConnectionDialog.centerToWindow(WindowManager.getDefault().getMainWindow());
            serverConnectionDialog.setVisible(true);
        }
    }
}

