/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.AddFolderDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdProjectIdentificationNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.util.ArrayList;
import javax.swing.tree.DefaultTreeModel;
import org.openide.windows.WindowManager;

public class AddIdentificationFolderAction
extends AbstractRSMAction {
    public AddIdentificationFolderAction(AbstractTree tree) {
        super("Add Identification Folder", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        AddFolderDialog dialog = AddFolderDialog.getDialog(WindowManager.getDefault().getMainWindow());
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            String name = dialog.getFolderName();
            AbstractNode n = selectedNodes[0];
            boolean isParentAProject = n.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION;
            final ArrayList<DataSetNode> nodesCreated = new ArrayList<DataSetNode>();
            IdentificationTree tree = IdentificationTree.getCurrentTree();
            final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            DataSetNode datasetNode = new DataSetNode((AbstractData)DataSetData.createTemporaryFolder((String)name));
            nodesCreated.add(datasetNode);
            datasetNode.setIsChanging(true);
            if (isParentAProject) {
                n.insert(datasetNode, n.getChildCount() - 1);
            } else {
                n.add(datasetNode);
            }
            treeModel.nodeStructureChanged(n);
            tree.expandNodeIfNeeded(n);
            Project project = null;
            DDataset parentDataset = null;
            DataSetNode parentDatasetNode = null;
            if (n.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
                project = ((IdProjectIdentificationNode)n).getProject();
                parentDataset = null;
            } else if (n.getType() == AbstractNode.NodeTypes.DATA_SET) {
                parentDatasetNode = (DataSetNode)n;
                parentDataset = parentDatasetNode.getDataset();
                project = parentDataset.getProject();
            }
            final ArrayList createdDatasetList = new ArrayList();
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (!success) {
                        return;
                    }
                    int nbNodes = nodesCreated.size();
                    for (int i = 0; i < nbNodes; ++i) {
                        DataSetNode datasetNode = (DataSetNode)nodesCreated.get(i);
                        DDataset dataset = (DDataset)createdDatasetList.get(i);
                        datasetNode.setIsChanging(false);
                        ((DataSetData)datasetNode.getData()).setDataset(dataset);
                        treeModel.nodeChanged(datasetNode);
                    }
                }
            };
            DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
            task.initCreateDatasetFolder(project, parentDataset, name, true, createdDatasetList);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        DDataset d;
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes != 1) {
            this.setEnabled(false);
            return;
        }
        AbstractNode node = selectedNodes[0];
        if (node.isChanging()) {
            this.setEnabled(false);
            return;
        }
        boolean enabled = false;
        if (node.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
            enabled = true;
        } else if (node.getType() == AbstractNode.NodeTypes.DATA_SET && (d = ((DataSetNode)node).getDataset()).isIdentification() && d.isFolder()) {
            enabled = true;
        }
        this.setEnabled(enabled);
    }
}

