/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.data.ChangeTypicalRule;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.ChangeTypicalProteinTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.ChangeTypicalProteinDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ChangeTypicalProteinJMSAction
extends AbstractRSMAction {
    public ChangeTypicalProteinJMSAction(AbstractTree tree) {
        super(NbBundle.getMessage(ChangeTypicalProteinJMSAction.class, (String)"CTL_ChangeTypicalProtein"), tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        ChangeTypicalProteinDialog dialog = ChangeTypicalProteinDialog.getDialog(WindowManager.getDefault().getMainWindow());
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            List<ChangeTypicalRule> rules = dialog.getChangeTypicalRules();
            IdentificationTree tree = IdentificationTree.getCurrentTree();
            DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            int nbNodes = selectedNodes.length;
            for (int i = 0; i < nbNodes; ++i) {
                final DataSetNode dataSetNode = (DataSetNode)selectedNodes[i];
                dataSetNode.setIsChanging(true);
                treeModel.nodeChanged(dataSetNode);
                final DDataset d = dataSetNode.getDataset();
                AbstractJMSCallback callback = new AbstractJMSCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success) {
                        ResultSummary rsm = d.getResultSummary();
                        if (rsm != null) {
                            rsm.getTransientData(null).setProteinSetArray(null);
                        }
                        dataSetNode.setIsChanging(false);
                        IdentificationTree tree = IdentificationTree.getCurrentTree();
                        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                        treeModel.nodeChanged(dataSetNode);
                    }
                };
                ChangeTypicalProteinTask task = new ChangeTypicalProteinTask(callback, d, rules);
                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
            }
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        for (AbstractNode node : selectedNodes) {
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                this.setEnabled(false);
                return;
            }
            DataSetNode dataSetNode = (DataSetNode)node;
            if (dataSetNode.hasResultSummary()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

