/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ClearDatasetAction
extends AbstractRSMAction {
    public ClearDatasetAction(AbstractTree tree) {
        super(NbBundle.getMessage(ClearDatasetAction.class, (String)"CTL_ClearAction"), tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        String msg = NbBundle.getMessage(ClearDatasetAction.class, (String)"ClearDatasetAction.help.text");
        String title = "Clear Dataset";
        int n = JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), msg, title, 0, 2);
        if (n == 0) {
            IdentificationTree tree = IdentificationTree.getCurrentTree();
            final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            int nbNodes = selectedNodes.length;
            for (int i = 0; i < nbNodes; ++i) {
                final DataSetNode node = (DataSetNode)selectedNodes[i];
                node.setIsChanging(true);
                treeModel.nodeChanged(node);
                AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                        if (success) {
                            DDataset dataset = node.getDataset();
                            dataset.setResultSummaryId(null);
                            dataset.setResultSummary(null);
                            if (!node.isLeaf()) {
                                dataset.setResultSetId(null);
                                dataset.setResultSet(null);
                            }
                        }
                        node.setIsChanging(false);
                        treeModel.nodeChanged(node);
                    }
                };
                DDataset dataset = node.getDataset();
                DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
                task.initClearDataset(dataset, !node.isLeaf());
                AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
            }
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        for (AbstractNode node : selectedNodes) {
            DataSetNode parentDatasetNode;
            AbstractNode parentNode;
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                this.setEnabled(false);
                return;
            }
            DataSetNode datasetNode = (DataSetNode)node;
            if (datasetNode.isLeaf()) {
                if (!datasetNode.hasResultSummary()) {
                    this.setEnabled(false);
                    return;
                }
                parentNode = (AbstractNode)datasetNode.getParent();
                if (parentNode.getType() != AbstractNode.NodeTypes.DATA_SET || !(parentDatasetNode = (DataSetNode)parentNode).isChanging() && !parentDatasetNode.hasResultSet() && !parentDatasetNode.hasResultSummary()) continue;
                this.setEnabled(false);
                return;
            }
            if (!datasetNode.hasResultSummary() && !datasetNode.hasResultSet()) {
                this.setEnabled(false);
                return;
            }
            parentNode = (AbstractNode)datasetNode.getParent();
            if (parentNode.getType() != AbstractNode.NodeTypes.DATA_SET || !(parentDatasetNode = (DataSetNode)parentNode).isChanging() && !parentDatasetNode.hasResultSet() && !parentDatasetNode.hasResultSummary()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

