/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationTree;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.tree.TreeNode;
import org.openide.util.NbBundle;

public class DeleteAction
extends AbstractRSMAction {
    public DeleteAction(AbstractTree tree) {
        super(NbBundle.getMessage(DeleteAction.class, (String)"CTL_DeleteAction"), tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        AbstractTree tree = this.getTree();
        if (tree == IdentificationTree.getCurrentTree()) {
            ((IdentificationTree)tree).moveToTrash(selectedNodes);
        } else if (tree == QuantitationTree.getCurrentTree()) {
            ((QuantitationTree)tree).moveToTrash(selectedNodes);
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        long commonProjectId = -1L;
        int nbSelectedNodes = selectedNodes.length;
        HashSet<AbstractNode> selectedNodesHashSet = new HashSet<AbstractNode>();
        for (int i = 0; i < nbSelectedNodes; ++i) {
            DataSetNode datasetNode;
            AbstractNode node = selectedNodes[i];
            if (!node.canBeDeleted()) {
                this.setEnabled(false);
                return;
            }
            if (selectedNodes[i] instanceof DataSetNode) {
                datasetNode = (DataSetNode)selectedNodes[i];
                long projectId = datasetNode.getDataset().getProject().getId();
                if (commonProjectId == -1L) {
                    commonProjectId = projectId;
                } else if (commonProjectId != projectId) {
                    this.setEnabled(false);
                    return;
                }
            } else {
                this.setEnabled(false);
                return;
            }
            selectedNodesHashSet.add(datasetNode);
            this.addChildren(datasetNode, selectedNodesHashSet);
        }
        for (AbstractNode node : selectedNodesHashSet) {
            DataSetNode parentDataset;
            AbstractNode parent = (AbstractNode)node.getParent();
            if (!(parent instanceof DataSetNode) || selectedNodesHashSet.contains(parentDataset = (DataSetNode)parent) || !parentDataset.hasResultSet() && !parentDataset.hasResultSummary()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    private void addChildren(AbstractNode parentNode, HashSet<AbstractNode> nodesHashSet) {
        Enumeration<TreeNode> e = parentNode.children();
        while (e.hasMoreElements()) {
            AbstractNode child = (AbstractNode)e.nextElement();
            nodesHashSet.add(child);
            this.addChildren(child, nodesHashSet);
        }
    }
}

