/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import org.openide.util.NbBundle;

public class DisplayMSQueryForRsetAction
extends AbstractRSMAction {
    public DisplayMSQueryForRsetAction(AbstractTree tree) {
        super(NbBundle.getMessage(DisplayMSQueryForRsetAction.class, (String)"CTL_DisplayMSQueryAction"), tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        int nbNodes = selectedNodes.length;
        for (int i = 0; i < nbNodes; ++i) {
            DataSetNode dataSetNode = (DataSetNode)selectedNodes[i];
            this.actionImpl(dataSetNode);
        }
    }

    private void actionImpl(DataSetNode dataSetNode) {
        final DDataset dataSet = ((DataSetData)dataSetNode.getData()).getDataset();
        if (!dataSetNode.hasResultSet()) {
            return;
        }
        ResultSet rset = dataSetNode.getResultSet();
        if (rset != null) {
            ResultSet.Type rsType = rset.getType();
            boolean mergedData = rsType == ResultSet.Type.USER || rsType == ResultSet.Type.DECOY_USER;
            WindowBox wbox = WindowBoxFactory.getMSQueriesWindowBoxForRset(dataSet.getName(), mergedData);
            wbox.setEntryData(dataSet.getProject().getId(), rset);
            DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
            win.open();
            win.requestActive();
        } else {
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    ResultSet rset = dataSet.getResultSet();
                    ResultSet.Type rsType = rset.getType();
                    boolean mergedData = rsType == ResultSet.Type.USER || rsType == ResultSet.Type.DECOY_USER;
                    WindowBox wbox = WindowBoxFactory.getMSQueriesWindowBoxForRset(dataSet.getName(), mergedData);
                    DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
                    win.open();
                    win.requestActive();
                    wbox.setEntryData(dataSet.getProject().getId(), rset);
                }
            };
            DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
            task.initLoadRsetAndRsm(dataSet);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes < 0) {
            this.setEnabled(false);
            return;
        }
        for (int i = 0; i < nbSelectedNodes; ++i) {
            AbstractNode node = selectedNodes[i];
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET && node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
                this.setEnabled(false);
                return;
            }
            DataSetNode dataSetNode = (DataSetNode)node;
            if (!dataSetNode.hasResultSet()) {
                this.setEnabled(false);
                return;
            }
            if (!dataSetNode.isMerged()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

