/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.studio.pattern.WindowSavedManager;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayAdjacencyMatrixAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayMSQueryAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayPTMClustersAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayPTMSitesAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayRsmPSMAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayRsmPeptidesAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayRsmProteinSetsAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplaySavedWindowAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayUserWindowAction;
import fr.proline.studio.rsmexplorer.actions.identification.ManageUserWindowsAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.util.NbBundle;

public class DisplayRsmAction
extends AbstractRSMAction {
    private DisplayRsmPSMAction m_displayRsmPSMAction;
    private DisplayRsmPeptidesAction m_displayRsmPeptidesAction;
    private DisplayRsmProteinSetsAction m_displayRsmProteinSetsAction;
    private DisplayPTMSitesAction m_displayPtmSiteProtein;
    private DisplayPTMClustersAction m_displayPtmClusterProtein;
    private DisplayAdjacencyMatrixAction m_displayAdjacencyMatrixAction;
    private DisplayMSQueryAction m_displayMSQueryAction;
    private DisplayUserWindowAction m_displayUserWindowAction;
    private ManageUserWindowsAction m_manageUserWindowsAction;
    private ArrayList<DisplaySavedWindowAction> m_displaySavedWindowActionList;
    private JMenu m_menu;

    public DisplayRsmAction(AbstractTree tree) {
        super(NbBundle.getMessage(DisplayRsmAction.class, (String)"CTL_DisplayRsmAction"), tree);
    }

    @Override
    public JMenuItem getPopupPresenter() {
        this.m_menu = new JMenu((String)this.getValue("Name"));
        this.m_displayMSQueryAction = new DisplayMSQueryAction(this.getTree());
        this.m_displayRsmPSMAction = new DisplayRsmPSMAction(this.getTree());
        this.m_displayRsmPeptidesAction = new DisplayRsmPeptidesAction(this.getTree());
        this.m_displayRsmProteinSetsAction = new DisplayRsmProteinSetsAction(this.getTree());
        this.m_displayPtmSiteProtein = new DisplayPTMSitesAction(this.getTree());
        this.m_displayPtmClusterProtein = new DisplayPTMClustersAction(this.getTree());
        this.m_displayAdjacencyMatrixAction = new DisplayAdjacencyMatrixAction(this.getTree());
        this.m_manageUserWindowsAction = new ManageUserWindowsAction('2', this.getTree());
        this.m_displayUserWindowAction = new DisplayUserWindowAction('2', this.getTree());
        ArrayList<String> savedWindowsList = WindowSavedManager.readSavedWindows();
        int nb = savedWindowsList.size();
        this.m_displaySavedWindowActionList = new ArrayList();
        for (int i = 0; i < nb; ++i) {
            String wndSaved = savedWindowsList.get(i);
            if (!WindowSavedManager.hasResultSummaryParameter(wndSaved)) continue;
            String name = WindowSavedManager.getWindowName(wndSaved);
            this.m_displaySavedWindowActionList.add(new DisplaySavedWindowAction(name, i, this.getTree()));
        }
        JMenuItem displayMSQueryItem = new JMenuItem(this.m_displayMSQueryAction);
        JMenuItem displayRsmPSMItem = new JMenuItem(this.m_displayRsmPSMAction);
        JMenuItem displayRsmPeptidesItem = new JMenuItem(this.m_displayRsmPeptidesAction);
        JMenuItem displayRsmProteinSetsItem = new JMenuItem(this.m_displayRsmProteinSetsAction);
        JMenuItem displayPtmSiteProteinItem = new JMenuItem(this.m_displayPtmSiteProtein);
        JMenuItem displayPtmClusterProteinItem = new JMenuItem(this.m_displayPtmClusterProtein);
        JMenuItem displayAdjacencyMatrixItem = new JMenuItem(this.m_displayAdjacencyMatrixAction);
        JMenuItem displayUserWindowItem = new JMenuItem(this.m_displayUserWindowAction);
        JMenuItem manageUserWindowsItem = new JMenuItem(this.m_manageUserWindowsAction);
        this.m_menu.add(displayMSQueryItem);
        this.m_menu.add(displayRsmPSMItem);
        this.m_menu.add(displayRsmPeptidesItem);
        this.m_menu.add(displayRsmProteinSetsItem);
        this.m_menu.add(displayAdjacencyMatrixItem);
        this.m_menu.addSeparator();
        this.m_menu.add(displayPtmSiteProteinItem);
        this.m_menu.add(displayPtmClusterProteinItem);
        this.m_menu.addSeparator();
        this.m_menu.add(displayUserWindowItem);
        this.m_menu.add(manageUserWindowsItem);
        int nbUserWindows = this.m_displaySavedWindowActionList.size();
        if (nbUserWindows > 0) {
            this.m_menu.addSeparator();
        }
        for (int i = 0; i < nbUserWindows; ++i) {
            this.m_menu.add(new JMenuItem(this.m_displaySavedWindowActionList.get(i)));
        }
        return this.m_menu;
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        this.m_displayRsmPSMAction.updateEnabled(selectedNodes);
        this.m_displayRsmPeptidesAction.updateEnabled(selectedNodes);
        this.m_displayRsmProteinSetsAction.updateEnabled(selectedNodes);
        this.m_displayPtmSiteProtein.updateEnabled(selectedNodes);
        this.m_displayPtmClusterProtein.updateEnabled(selectedNodes);
        this.m_displayAdjacencyMatrixAction.updateEnabled(selectedNodes);
        this.m_displayUserWindowAction.updateEnabled(selectedNodes);
        this.m_manageUserWindowsAction.updateEnabled(selectedNodes);
        this.m_displayMSQueryAction.updateEnabled(selectedNodes);
        boolean listEnabled = false;
        for (int i = 0; i < this.m_displaySavedWindowActionList.size(); ++i) {
            this.m_displaySavedWindowActionList.get(i).updateEnabled(selectedNodes);
            listEnabled |= this.m_displaySavedWindowActionList.get(i).isEnabled();
        }
        boolean isEnabled = this.m_displayRsmPSMAction.isEnabled() || this.m_displayRsmPeptidesAction.isEnabled() || this.m_displayPtmClusterProtein.isEnabled() || this.m_displayRsmProteinSetsAction.isEnabled() || this.m_displayPtmSiteProtein.isEnabled() || this.m_displayMSQueryAction.isEnabled() || this.m_displayUserWindowAction.isEnabled() || this.m_manageUserWindowsAction.isEnabled() || listEnabled;
        this.setEnabled(isEnabled);
        this.m_menu.setEnabled(isEnabled);
    }
}

