/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.ClearProjectData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseClearProjectTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class EmptyTrashAction
extends AbstractRSMAction {
    public EmptyTrashAction(AbstractTree tree) {
        super(NbBundle.getMessage(EmptyTrashAction.class, (String)"CTL_EmptyTrashAction"), tree);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        AbstractNode n = selectedNodes[0];
        this.setEnabled(!n.isChanging() && !n.isLeaf());
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        InfoDialog exitDialog = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Confirm Erasing of Recycle Bin", "Are you sure you want to erase the contents of the Recycle Bin?");
        exitDialog.setButtonName(0, "Yes");
        exitDialog.setButtonName(1, "No");
        exitDialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
        exitDialog.setVisible(true);
        if (exitDialog.getButtonClicked() == 1) {
            return;
        }
        final AbstractNode n = selectedNodes[0];
        final DDataset trashDataset = ((DataSetNode)n).getDataset();
        final boolean identificationDataset = this.getTree() == IdentificationTree.getCurrentTree();
        final DefaultTreeModel treeModel = (DefaultTreeModel)this.getTree().getModel();
        n.setIsChanging(true);
        Project project = trashDataset.getProject();
        Long projectId = project.getId();
        ArrayList listDataToClear = new ArrayList();
        List<ClearProjectData> openedData = ProjectExplorerPanel.getOpenedData(project);
        AbstractDatabaseCallback loadClearCallback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                        n.setIsChanging(false);
                        if (success) {
                            n.removeAllChildren();
                            treeModel.nodeStructureChanged(n);
                        } else {
                            treeModel.nodeChanged(n);
                        }
                    }
                };
                DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
                task.initEmptyTrash(trashDataset, identificationDataset);
                AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
            }
        };
        DatabaseClearProjectTask clearDsTask = new DatabaseClearProjectTask(loadClearCallback);
        clearDsTask.initLoadDataToClearTrash(projectId, listDataToClear, openedData);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)clearDsTask);
    }
}

