/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.actions.identification.ExportDatasetJMSAction;
import fr.proline.studio.rsmexplorer.actions.identification.ExportFastaAction;
import fr.proline.studio.rsmexplorer.actions.identification.ExportMzIdentMLAction;
import fr.proline.studio.rsmexplorer.actions.identification.ExportSpectraListJMSAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.util.NbBundle;

public class ExportAction
extends AbstractRSMAction {
    private AbstractRSMAction m_exportDatasetAction;
    private AbstractRSMAction m_exportPeakViewSpectraAction;
    private AbstractRSMAction m_exportSpectronautSpectraAction;
    private AbstractRSMAction m_exportMzIdentMLAction;
    private AbstractRSMAction m_exporFastaAction;
    private JMenu m_menu;

    public ExportAction(AbstractTree tree) {
        super(NbBundle.getMessage(ExportAction.class, (String)"CTL_ExportAction"), tree);
    }

    @Override
    public JMenuItem getPopupPresenter() {
        this.m_menu = new JMenu((String)this.getValue("Name"));
        this.m_exportDatasetAction = new ExportDatasetJMSAction(this.getTree());
        this.m_exportMzIdentMLAction = this.getTree() == IdentificationTree.getCurrentTree() ? new ExportMzIdentMLAction(this.getTree()) : null;
        JMenuItem exportDatasetItem = new JMenuItem(this.m_exportDatasetAction);
        this.m_menu.add(exportDatasetItem);
        if (this.m_exportMzIdentMLAction != null) {
            JMenuItem exportMzIdentMLItem = new JMenuItem(this.m_exportMzIdentMLAction);
            this.m_menu.add(exportMzIdentMLItem);
        }
        JMenu exportMenu = new JMenu(NbBundle.getMessage(ExportAction.class, (String)"CTL_ExportSpectraListAction"));
        this.m_exportPeakViewSpectraAction = new ExportSpectraListJMSAction(this.getTree(), ExportSpectraListJMSAction.FormatCompatibility.PeakView);
        this.m_exportSpectronautSpectraAction = new ExportSpectraListJMSAction(this.getTree(), ExportSpectraListJMSAction.FormatCompatibility.Spectronaut);
        JMenuItem exportSpectraItem = new JMenuItem(this.m_exportPeakViewSpectraAction);
        exportMenu.add(exportSpectraItem);
        exportSpectraItem = new JMenuItem(this.m_exportSpectronautSpectraAction);
        exportMenu.add(exportSpectraItem);
        this.m_menu.add(exportMenu);
        this.m_exporFastaAction = new ExportFastaAction(this.getTree());
        JMenuItem exportFastaItem = new JMenuItem(this.m_exporFastaAction);
        this.m_menu.add(exportFastaItem);
        return this.m_menu;
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        this.m_exportDatasetAction.updateEnabled(selectedNodes);
        if (this.m_exportMzIdentMLAction != null) {
            this.m_exportMzIdentMLAction.updateEnabled(selectedNodes);
        }
        this.m_exportSpectronautSpectraAction.updateEnabled(selectedNodes);
        this.m_exportPeakViewSpectraAction.updateEnabled(selectedNodes);
        boolean isEnabled = this.m_exportDatasetAction.isEnabled() || this.m_exportSpectronautSpectraAction.isEnabled() || this.m_exportPeakViewSpectraAction.isEnabled() || this.m_exportMzIdentMLAction != null && this.m_exportMzIdentMLAction.isEnabled();
        this.setEnabled(isEnabled);
        this.m_menu.setEnabled(isEnabled);
    }
}

