/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.DownloadProcessedFileTask;
import fr.proline.studio.dpm.task.jms.ExportDatasetTask;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.dialog.exporter.ExportPrideDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import java.util.ArrayList;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportRSM2PrideJMSAction
extends AbstractRSMAction {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    public ExportRSM2PrideJMSAction(AbstractTree tree) {
        super(NbBundle.getMessage(ExportRSM2PrideJMSAction.class, (String)"CTL_ExportPrideAction"), tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        final DataSetNode dataSetNode = (DataSetNode)selectedNodes[0];
        final ExportPrideDialog dialog = new ExportPrideDialog(WindowManager.getDefault().getMainWindow());
        DefaultDialog.ProgressTask task = new DefaultDialog.ProgressTask(){

            public int getMinValue() {
                return 0;
            }

            public int getMaxValue() {
                return 100;
            }

            protected Object doInBackground() throws Exception {
                final AbstractJMSCallback downloadCallback = new AbstractJMSCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success) {
                        if (success) {
                            this.setProgress(100);
                        } else {
                            this.setProgress(100);
                        }
                    }
                };
                final ArrayList _filePath = new ArrayList();
                final ArrayList _JMSNodeId = new ArrayList();
                AbstractJMSCallback exportCallback = new AbstractJMSCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success) {
                        if (success) {
                            String fileName = dialog.getFileName();
                            if (!fileName.endsWith(".xml") && !fileName.endsWith(".XML")) {
                                fileName = fileName + ".xml";
                            }
                            DownloadProcessedFileTask task = new DownloadProcessedFileTask(downloadCallback, fileName, (String)_filePath.get(0), (String)_JMSNodeId.get(0));
                            AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                        } else {
                            this.setProgress(100);
                        }
                    }
                };
                ArrayList<DDataset> dsets = new ArrayList<DDataset>();
                dsets.add(dataSetNode.getDataset());
                ExportDatasetTask exportTask = new ExportDatasetTask(exportCallback, dsets, null, _filePath, _JMSNodeId, ExportDatasetTask.ExporterFormat.PRIDE, dialog.getExportParams());
                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)exportTask);
                return null;
            }
        };
        dialog.setTask(task);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes != 1) {
            this.setEnabled(false);
            return;
        }
        AbstractNode node = selectedNodes[0];
        AbstractNode.NodeTypes nodeType = node.getType();
        if (nodeType != AbstractNode.NodeTypes.DATA_SET && node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
            this.setEnabled(false);
            return;
        }
        DataSetNode datasetNode = (DataSetNode)node;
        if (!datasetNode.hasResultSummary()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

