/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.dialog.MSDiagDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import java.util.ArrayList;
import java.util.HashMap;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class GenerateMSDiagReportAction
extends AbstractRSMAction {
    public GenerateMSDiagReportAction(AbstractTree tree) {
        super(NbBundle.getMessage(GenerateMSDiagReportAction.class, (String)"CTL_GenerateMSDiagReportAction"), tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        int nbNodes = selectedNodes.length;
        MSDiagDialog dialog = MSDiagDialog.getDialog(WindowManager.getDefault().getMainWindow());
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        HashMap<String, String> msdiagParams = null;
        if (dialog.getButtonClicked() != 0) {
            return;
        }
        msdiagParams = dialog.getMSDiagSettings();
        ArrayList<HashMap<String, String>> resultMessages = new ArrayList<HashMap<String, String>>(0);
        resultMessages.add(msdiagParams);
        for (int i = 0; i < nbNodes; ++i) {
            DataSetNode dataSetNode = (DataSetNode)selectedNodes[i];
            this.actionImpl(dataSetNode, resultMessages);
        }
    }

    private void actionImpl(DataSetNode dataSetNode, ArrayList resultMessages) {
        final DDataset dataSet = ((DataSetData)dataSetNode.getData()).getDataset();
        if (!dataSetNode.hasResultSet()) {
            return;
        }
        ResultSet rset = dataSetNode.getResultSet();
        if (rset != null) {
            WindowBox wbox = WindowBoxFactory.getMSDiagWindowBox(dataSet.getName() + " Quality Control", (HashMap)resultMessages.get(0));
            wbox.setEntryData(dataSet.getProject().getId(), rset);
            DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
            win.open();
            win.requestActive();
        } else {
            final WindowBox wbox = WindowBoxFactory.getMSDiagWindowBox(dataSet.getName() + " Quality Control", (HashMap)resultMessages.get(0));
            DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
            win.open();
            win.requestActive();
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    wbox.setEntryData(dataSet.getProject().getId(), dataSet.getResultSet());
                }
            };
            DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
            task.initLoadRsetAndRsm(dataSet);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes < 0) {
            this.setEnabled(false);
            return;
        }
        for (int i = 0; i < nbSelectedNodes; ++i) {
            AbstractNode node = selectedNodes[i];
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET && node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
                this.setEnabled(false);
                return;
            }
            DataSetNode dataSetNode = (DataSetNode)node;
            if (!dataSetNode.hasResultSet()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET || dataSetNode.isLeaf()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

