/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.RetrieveBioSeqTask;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.tree.DefaultTreeModel;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveBioSeqJMSAction
extends AbstractRSMAction {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    public RetrieveBioSeqJMSAction(AbstractTree tree) {
        super(NbBundle.getMessage(RetrieveBioSeqJMSAction.class, (String)"CTL_RetrieveBioSeq"), tree);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        for (AbstractNode node : selectedNodes) {
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                this.setEnabled(false);
                return;
            }
            DataSetNode dataSetNode = (DataSetNode)node;
            if (dataSetNode.hasResultSummary()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getTree().getModel();
        final ArrayList<DataSetNode> datasets = new ArrayList<DataSetNode>();
        ArrayList<Long> rsmIds = new ArrayList<Long>();
        int nbNodes = selectedNodes.length;
        final ArrayList<ResultSummary> rsms2Clean = new ArrayList<ResultSummary>();
        for (int i = 0; i < nbNodes; ++i) {
            DataSetNode dataSetNode = (DataSetNode)selectedNodes[i];
            datasets.add(dataSetNode);
            dataSetNode.setIsChanging(true);
            treeModel.nodeChanged(dataSetNode);
            DDataset d = dataSetNode.getDataset();
            ResultSummary rsm = d.getResultSummary();
            if (rsm != null) {
                rsms2Clean.add(rsm);
            }
            rsmIds.add(d.getResultSummaryId());
        }
        Long projectId = ((DataSetNode)selectedNodes[0]).getDataset().getProject().getId();
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                if (!success) {
                    String msg = this.getTaskError().getErrorTitle();
                    InfoDialog errorDialog = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "JMSTask Error", "Error: " + msg + "\nnProtein Sequence can't be retrived, Check if the Sequence Repository Server is installed and started");
                    errorDialog.setButtonVisible(1, false);
                    errorDialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                    errorDialog.setVisible(true);
                }
                IdentificationTree tree = IdentificationTree.getCurrentTree();
                DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                for (DataSetNode dataSetNode : datasets) {
                    dataSetNode.setIsChanging(false);
                    treeModel.nodeChanged(dataSetNode);
                }
                for (ResultSummary rsm : rsms2Clean) {
                    rsm.getTransientData(null).setProteinSetArray(null);
                }
            }
        };
        RetrieveBioSeqTask task = new RetrieveBioSeqTask(callback, rsmIds, projectId.longValue(), true);
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
    }
}

