/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.UpdateSpectraParamsTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.UpdatePeaklistSoftDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.util.ArrayList;
import javax.swing.tree.DefaultTreeModel;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatePeaklistSoftwareAction
extends AbstractRSMAction {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    public UpdatePeaklistSoftwareAction(AbstractTree tree) {
        super(NbBundle.getMessage(UpdatePeaklistSoftwareAction.class, (String)"CTL_UpdatePeaklistSoft"), tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        Long peaklistSoftID;
        UpdatePeaklistSoftDialog dialog = UpdatePeaklistSoftDialog.getDialog(WindowManager.getDefault().getMainWindow());
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0 && (peaklistSoftID = dialog.getSelectedPeaklistSoftwareId()) != null) {
            int nbrNodes = selectedNodes.length;
            ArrayList<Long> rsIds = new ArrayList<Long>();
            Long projectId = ((DataSetNode)selectedNodes[0]).getDataset().getProject().getId();
            IdentificationTree tree = IdentificationTree.getCurrentTree();
            DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            final ArrayList<DataSetNode> selectedDSNodes = new ArrayList<DataSetNode>();
            for (int i = 0; i < nbrNodes; ++i) {
                DataSetNode dataSetNode = (DataSetNode)selectedNodes[i];
                selectedDSNodes.add(dataSetNode);
                rsIds.add(dataSetNode.getResultSetId());
                dataSetNode.setIsChanging(true);
                treeModel.nodeChanged(dataSetNode);
            }
            AbstractJMSCallback callback = new AbstractJMSCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success) {
                    IdentificationTree tree = IdentificationTree.getCurrentTree();
                    DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                    for (DataSetNode node : selectedDSNodes) {
                        node.setIsChanging(false);
                        treeModel.nodeChanged(node);
                    }
                }
            };
            UpdateSpectraParamsTask task = new UpdateSpectraParamsTask(callback, projectId, rsIds, peaklistSoftID);
            AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        for (AbstractNode node : selectedNodes) {
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                this.setEnabled(false);
                return;
            }
            DataSetNode dataSetNode = (DataSetNode)node;
            if (dataSetNode.isLeaf() && dataSetNode.hasResultSet()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

