/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.table;

import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxAdjacencyMatrixChoice;
import fr.proline.studio.pattern.DataboxManager;
import fr.proline.studio.pattern.ParameterDistance;
import fr.proline.studio.rsmexplorer.actions.table.DisplayViewInNewWindowAction;
import fr.proline.studio.table.AbstractTableAction;
import java.awt.Component;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;

public class DisplayMenuAction
extends AbstractTableAction {
    private JMenu m_menu = new JMenu("Display");

    public DisplayMenuAction() {
        super("Display");
    }

    public void actionPerformed(int col, int row, int[] selectedRows, JTable table) {
    }

    public void updateEnabled(int row, int col, int[] selectedRows, JTable table) {
        this.setEnabled(true);
    }

    public Component getPopupPresenter() {
        return this.m_menu;
    }

    public void populate(AbstractDataBox dataBox) {
        this.m_menu.removeAll();
        boolean hasSubActions = false;
        AbstractDataBox.DataboxStyle previousStyle = null;
        for (AbstractDataBox.DataboxStyle style : AbstractDataBox.DataboxStyle.values()) {
            TreeMap<ParameterDistance, AbstractDataBox> dataBoxMap = DataboxManager.getDataboxManager().findCompatibleDataboxList(dataBox, dataBox.getImportantInParameterClass());
            Iterator<ParameterDistance> it = dataBoxMap.descendingKeySet().iterator();
            while (it.hasNext()) {
                AbstractDataBox destDatabox = dataBoxMap.get(it.next());
                if (destDatabox.getStyle() != style) continue;
                if (previousStyle != null && previousStyle != style) {
                    this.m_menu.addSeparator();
                }
                previousStyle = style;
                String description = destDatabox instanceof DataBoxAdjacencyMatrixChoice ? "Proteins Adjacency Matrix" : destDatabox.getDescription();
                DisplayViewInNewWindowAction displayAction = new DisplayViewInNewWindowAction(dataBox, destDatabox, description);
                JMenuItem displayOptionMenuItem = new JMenuItem(displayAction);
                this.m_menu.add(displayOptionMenuItem);
                hasSubActions = true;
            }
        }
        this.m_menu.setEnabled(hasSubActions);
    }
}

