/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.table;

import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxFrozenCopy;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public class DisplayViewInNewWindowAction
extends AbstractAction {
    private AbstractDataBox m_sourceBox;
    private AbstractDataBox m_destinationBox;

    public DisplayViewInNewWindowAction(AbstractDataBox sourceBox, AbstractDataBox destinationBox, String description) {
        super(description);
        Image img = destinationBox.getDefaultIcon();
        if (img != null) {
            this.putValue("SmallIcon", new ImageIcon(img));
        }
        this.m_sourceBox = sourceBox;
        try {
            this.m_destinationBox = (AbstractDataBox)destinationBox.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataBoxFrozenCopy dataBoxFrozenCopy = new DataBoxFrozenCopy(this.m_sourceBox);
        dataBoxFrozenCopy.addNextDataBox(this.m_destinationBox);
        String dataName = this.m_sourceBox.getImportantOutParameterValue();
        if (dataName != null && dataName.length() > 12) {
            dataName = dataName.substring(0, 10) + "...";
        }
        WindowBox wbox = WindowBoxFactory.getDetailWindowBox(dataName, dataName + ": " + this.m_destinationBox.getDescription(), this.m_destinationBox);
        DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
        win.open();
        win.requestActive();
        Class[] classes = this.m_sourceBox.getImportantInParameterClass();
        for (int i = 0; i < classes.length; ++i) {
            dataBoxFrozenCopy.addDataChanged(classes[i], null);
        }
        dataBoxFrozenCopy.propagateDataChanged();
    }
}

