/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.xic;

import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.actions.xic.CreateXICBiologicalNodeAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.xic.QuantExperimentalDesignTree;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.util.NbBundle;

public class CreateAction
extends AbstractRSMAction {
    private CreateXICBiologicalNodeAction m_createSampleAction;
    private CreateXICBiologicalNodeAction m_createGroupAction;
    private CreateXICBiologicalNodeAction m_createChannelAction;
    private JMenu m_menu;
    private final QuantExperimentalDesignTree m_tree;
    private JMenuItem m_createSampleItem;
    private JMenuItem m_createGroupItem;
    private JMenuItem m_createChannelItem;

    public CreateAction(QuantExperimentalDesignTree tree) {
        super(NbBundle.getMessage(CreateAction.class, (String)"CTL_CreateAction"), tree);
        this.m_tree = tree;
    }

    @Override
    public JMenuItem getPopupPresenter() {
        if (this.m_menu == null) {
            this.m_menu = new JMenu((String)this.getValue("Name"));
            this.m_createSampleAction = new CreateXICBiologicalNodeAction(NbBundle.getMessage(CreateAction.class, (String)"CTL_CreateSampleAction"), AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE, this.m_tree);
            this.m_createGroupAction = new CreateXICBiologicalNodeAction(NbBundle.getMessage(CreateAction.class, (String)"CTL_CreateGroupAction"), AbstractNode.NodeTypes.BIOLOGICAL_GROUP, this.m_tree);
            this.m_createChannelAction = new CreateXICBiologicalNodeAction(NbBundle.getMessage(CreateAction.class, (String)"CTL_CreateChannelAction"), AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS, this.m_tree);
            this.m_createSampleItem = new JMenuItem(this.m_createSampleAction);
            this.m_createGroupItem = new JMenuItem(this.m_createGroupAction);
            this.m_createChannelItem = new JMenuItem(this.m_createChannelAction);
        }
        return this.m_menu;
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        if (selectedNodes.length != 1) {
            this.setEnabled(false);
            return;
        }
        AbstractNode.NodeTypes selectedNodeType = selectedNodes[0].getType();
        this.m_menu.removeAll();
        switch (selectedNodeType) {
            case DATA_SET: {
                this.m_menu.add(this.m_createGroupItem);
                this.m_menu.add(this.m_createSampleItem);
                this.m_menu.add(this.m_createChannelItem);
                break;
            }
            case BIOLOGICAL_GROUP: {
                this.m_menu.add(this.m_createSampleItem);
                break;
            }
            case BIOLOGICAL_SAMPLE: {
                this.m_menu.add(this.m_createChannelItem);
                break;
            }
        }
        this.m_menu.setEnabled(this.m_menu.getItemCount() != 0);
        this.setEnabled(this.m_menu.isEnabled());
    }
}

